package io.kiw.speedy.marshaller;


import java.nio.ByteBuffer;

public class MessageMarshaller {
    public static void marshallIndividualMessage(String key, byte[] allApplicationData, int offset, int writeLength, int remainingEventDataLength, ByteBuffer packetBuffer, boolean firstMessageOfEvent, long eventSequenceNumber) {
        packetBuffer.putInt(key.hashCode()); // key identifier
        packetBuffer.putInt(remainingEventDataLength);
        if(firstMessageOfEvent)
        {
            packetBuffer.putLong(eventSequenceNumber);
        }
        packetBuffer.put(allApplicationData, offset, writeLength);
    }
}
