package io.kiw.speedy.publisher;


import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;

public class SchedulerThread {

    public static final int WAIT_TO_CHECK_TIME = 10000;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "Scheduler-Thread"));
    private final List<ScheduledJob> scheduledJobs = new ArrayList<>();
    private final LongSupplier nanoTimeRetriever;
    private boolean started;

    public SchedulerThread(LongSupplier nanoTimeRetriever) {
        this.nanoTimeRetriever = nanoTimeRetriever;
    }

    public void addJob(final ScheduledJob scheduledJob)
    {
        if(!started)
        {
            scheduledJobs.add(scheduledJob);
        }
        else
        {
            throw new RuntimeException("Can't add a new job while already started");
        }
    }
    public void start()
    {
        started = true;
        scheduledExecutorService.scheduleWithFixedDelay(this::pulse,
                WAIT_TO_CHECK_TIME, WAIT_TO_CHECK_TIME, TimeUnit.NANOSECONDS);
    }

    public void pulse() {
        long nanoTime = nanoTimeRetriever.getAsLong();
        scheduledJobs.forEach(j -> j.run(nanoTime));
    }

    public void stop() {
        scheduledExecutorService.shutdown();
    }

    public static class ScheduledJob {
        private final long interval;
        private long lastRunTime;
        private final LongConsumer consumer;

        public ScheduledJob(long interval, long lastRunTime, LongConsumer consumer) {

            this.interval = interval;
            this.lastRunTime = lastRunTime;
            this.consumer = consumer;
        }

        public void run(long currentTime) {
            if(currentTime > lastRunTime + interval)
            {
                consumer.accept(currentTime);
                lastRunTime = currentTime;
            }
        }
    }
}
