package io.kiw.speedy.subscriber;

import io.kiw.speedy.publisher.PublishPromise;

import java.nio.ByteBuffer;

public class GenericHandler {

    private final SpeedyMessageReplyHandler speedyMessageReplyHandler;
    private final ResponderPrimer responderPrimer;

    public GenericHandler(SpeedyMessageHandler speedyMessageHandler) {
        speedyMessageReplyHandler = convertHandler(speedyMessageHandler);
        this.responderPrimer = GenericHandler::noOp;
    }

    public GenericHandler(SpeedyMessageReplyHandler speedyMessageHandler) {
        speedyMessageReplyHandler = speedyMessageHandler;
        this.responderPrimer = GenericHandler::setUpResponder;
    }

    public void handleMessage(ByteBuffer eventBuffer, Responder responder, int publisherIdentifier, long eventSequenceNumber, PublishPromise publishPromise) {
        responderPrimer.primeResponder(responder, publisherIdentifier, eventSequenceNumber, publishPromise);
        speedyMessageReplyHandler.handleMessage(eventBuffer, responder);
    }

    private static SpeedyMessageReplyHandler convertHandler(final SpeedyMessageHandler speedyMessageHandler) {
        return (applicationData, responder) -> speedyMessageHandler.handleMessage(applicationData);
    }


    private static Responder setUpResponder(Responder responder, int publisherIdentifier, long eventSequenceNumber, PublishPromise publishPromise)
    {
        return responder.setAndGet(publisherIdentifier, eventSequenceNumber, publishPromise);
    }

    private static Responder noOp(Responder responder, int publisherIdentifier, long eventSequenceNumber, PublishPromise publishPromise)
    {
        return responder;
    }

    private interface ResponderPrimer
    {
        Responder primeResponder(Responder responder, int publisherIdentifier, long eventSequenceNumber, PublishPromise publishPromise);
    }

}
