package io.kiw.speedy.subscriber;

import io.kiw.speedy.publisher.PublishPromise;

import java.nio.ByteBuffer;

import static io.kiw.speedy.builder.KeysBuilder.RESPONSE_SUFFIX;
import static io.kiw.speedy.marshaller.PacketHandlerImpl.MAX_EVENT_SIZE;

public class Responder {
    private final String channelName;
    private int publisherIdentifier;
    private long eventSequenceCorrelationNumber = -1;
    private final ByteBuffer responderBuffer = ByteBuffer.allocateDirect(MAX_EVENT_SIZE);
    private PublishPromise publishPromise;

    public Responder(String channelName) {

        this.channelName = channelName;
    }

    public void respond() {

        responderBuffer.flip();
        byte[] bytes = new byte[responderBuffer.remaining()];
        responderBuffer.get(bytes);
        publishPromise.publish(channelName.hashCode() + "-" + publisherIdentifier + RESPONSE_SUFFIX, bytes);
    }

    public Responder setAndGet(int publisherIdentifier, long eventSequenceNumber, PublishPromise publishPromise) {
        this.publisherIdentifier = publisherIdentifier;
        this.eventSequenceCorrelationNumber = eventSequenceNumber;
        this.publishPromise = publishPromise;
        responderBuffer.clear();
        responderBuffer.putLong(eventSequenceCorrelationNumber);
        return this;
    }

    public ByteBuffer getResponderBuffer() {
        return responderBuffer;
    }
}
