package io.kiw.speedy.subscriber;

import io.kiw.speedy.publisher.PublishPromise;

import java.nio.ByteBuffer;

public class SubscriberMultiThreadHandler implements SubscriberThreadHandler {
    private final EventPublisher<HandleMessageEvent> tetryonQueue;
    private final HandleMessageEvent handleMessageEvent = new HandleMessageEvent();
    public SubscriberMultiThreadHandler(EventPublisher<HandleMessageEvent> tetryonQueue) {
        this.tetryonQueue = tetryonQueue;
    }

    @Override
    public void handleMessage(GenericHandler speedyMessageHandler, ByteBuffer eventBuffer, int publisherIdentifier, long eventSequenceNumber, PublishPromise publishPromise) {
        handleMessageEvent.overwrite(speedyMessageHandler, eventBuffer, publisherIdentifier, eventSequenceNumber, publishPromise);
        tetryonQueue.publishEvent(handleMessageEvent);
    }

}
