package io.kiw.speedy.wiring;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public class NetworkQueue {
    private final Runnable fragmentHandler;
    private final Queue<byte[]> fragments = new ArrayBlockingQueue<>(10000);

    public NetworkQueue(Runnable fragmentHandler) {

        this.fragmentHandler = fragmentHandler;
    }

    public void putFragment(byte[] bytes) {
        fragments.add(bytes);
    }

    public void executeFragments() {
        if(fragmentHandler != null)
        {
            while(fragments.size() > 0)
            {
                fragmentHandler.run();
            }
        }

    }

    public byte[] getFragment() {
        return fragments.poll();
    }

}
