/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy;

import io.kiw.speedy.SpeedyHost;
import io.kiw.speedy.SpeedyMessagingImpl;
import io.kiw.speedy.builder.SpeedyChannel;
import io.kiw.speedy.builder.SpeedyNetwork;
import io.kiw.speedy.builder.SpeedyNetworkBuilder;
import io.kiw.speedy.parallel.ParallelHelper;
import java.io.IOException;
import java.nio.charset.Charset;

public class SimpleExample {
    private static final String EVENT_KEY = "eventKey";
    private static final String CHANNEL_NAME = "simplePubSub";

    public static void main(String[] args) throws InterruptedException, IOException {
        ExampleNetwork exampleNetwork = new ExampleNetwork();
        SpeedyMessagingImpl publisher = exampleNetwork.buildPublisher();
        SpeedyMessagingImpl subscriber = exampleNetwork.buildSubscriber();
        ExampleSubscriber.addSubscriptionHandler(subscriber);
        Runnable[] runnableArray = new Runnable[2];
        runnableArray[0] = subscriber::start;
        runnableArray[1] = publisher::start;
        ParallelHelper.parallel(runnableArray);
        ExamplePublisher.sendMessages(publisher);
        publisher.close();
        subscriber.close();
    }

    private static class ExamplePublisher {
        private ExamplePublisher() {
        }

        public static void sendMessages(SpeedyMessagingImpl publisher) {
            for (int i = 0; i < 10; ++i) {
                publisher.publish(SimpleExample.EVENT_KEY, ("hello, this is message " + i).getBytes(Charset.forName("UTF-8")));
            }
        }
    }

    private static class ExampleSubscriber {
        private ExampleSubscriber() {
        }

        public static void addSubscriptionHandler(SpeedyMessagingImpl subscriber) {
            subscriber.subscribe(SimpleExample.EVENT_KEY, message -> {
                byte[] bytes = new byte[message.remaining()];
                message.get(bytes);
                System.out.println(new String(bytes));
            });
        }
    }

    private static class ExampleNetwork {
        private final SpeedyHost publisherHost = new SpeedyHost("publisher", "127.0.0.1", 8543);
        private SpeedyHost susbcriberHost = new SpeedyHost("subscriber", "127.0.0.1", 8544);
        public SpeedyNetwork exampleNetwork = new SpeedyNetworkBuilder().addChannel(SpeedyChannel.newChannel("simplePubSub").withPublishers(this.publisherHost).forKeys("eventKey").toSubscribers(this.susbcriberHost)).buildNetwork();

        private ExampleNetwork() {
        }

        public SpeedyMessagingImpl buildPublisher() {
            return this.exampleNetwork.createInstanceBuilderFromPerspective(this.publisherHost).build();
        }

        public SpeedyMessagingImpl buildSubscriber() {
            return this.exampleNetwork.createInstanceBuilderFromPerspective(this.susbcriberHost).build();
        }
    }
}

