/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy;

import io.kiw.speedy.SpeedyHost;
import io.kiw.speedy.exception.SpeedyMessagingInitiationException;
import io.kiw.speedy.helper.ImmutableIntMap;
import io.kiw.speedy.subscriber.SubscriberChannelState;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class SpeedyConnection {
    private final SpeedyHost remoteHost;
    private final AtomicBoolean theyHaveAcknowledgedUs = new AtomicBoolean(false);
    private final AtomicBoolean weHaveAcknowledgedThem = new AtomicBoolean(false);
    private final Set<Integer> keyIdentifiers;
    private final ImmutableIntMap<SubscriberChannelState> channelSequenceStates;

    public SpeedyConnection(SpeedyHost remoteHost, Set<Integer> keyIdentifiers, ImmutableIntMap<SubscriberChannelState> channelSequenceStates) {
        this.remoteHost = remoteHost;
        this.keyIdentifiers = keyIdentifiers;
        this.channelSequenceStates = channelSequenceStates;
    }

    public SpeedyHost getHost() {
        return this.remoteHost;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpeedyConnection that = (SpeedyConnection)o;
        return this.remoteHost != null ? this.remoteHost.equals(that.remoteHost) : that.remoteHost == null;
    }

    public int hashCode() {
        return this.remoteHost != null ? this.remoteHost.hashCode() : 0;
    }

    public boolean theyHaveAcknowledgedUs() {
        return this.theyHaveAcknowledgedUs.get();
    }

    public void theyAcknowledgeUs() {
        this.theyHaveAcknowledgedUs.set(true);
    }

    public void weAcknowledgeThem() {
        this.weHaveAcknowledgedThem.set(true);
    }

    public boolean weHaveAcknowledgedThem() {
        return this.weHaveAcknowledgedThem.get();
    }

    public void assertAllKeysHaveBeenSubscribedTo(Set<Integer> subscribedKeys) {
        for (int registeredKey : this.keyIdentifiers) {
            if (subscribedKeys.contains(registeredKey)) continue;
            throw new SpeedyMessagingInitiationException("Not all registered keys have been subscribed to");
        }
    }

    public boolean containsRegistrationToKey(String key) {
        return this.keyIdentifiers.contains(key.hashCode());
    }

    public SubscriberChannelState getChannelSequenceState(int channelIdentifier) {
        return this.channelSequenceStates.get(channelIdentifier);
    }
}

