/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SpeedyHost {
    private final String name;
    private final byte[] ipAddressAsBytes;
    private final int port;
    private final InetAddress inetAddress;
    private final byte[] marshalled;
    private final InetSocketAddress inetSocketAddress;

    public SpeedyHost(String name, String ipAddress, int port) {
        this.name = name;
        this.ipAddressAsBytes = SpeedyHost.deriveIpAddressBytesByString(ipAddress);
        this.inetAddress = SpeedyHost.deriveInetAddressFromString(ipAddress);
        this.port = port;
        this.marshalled = SpeedyHost.marshall(name, this.ipAddressAsBytes, port);
        this.inetSocketAddress = new InetSocketAddress(this.inetAddress, port);
    }

    public SpeedyHost(String name, byte[] ipAddressBytes, int port) {
        this.name = name;
        this.ipAddressAsBytes = ipAddressBytes;
        this.inetAddress = this.deriveInetAddressFromBytes(this.ipAddressAsBytes);
        this.port = port;
        this.marshalled = SpeedyHost.marshall(name, this.ipAddressAsBytes, port);
        this.inetSocketAddress = new InetSocketAddress(this.inetAddress, port);
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public byte[] getIpAddressAsBytes() {
        return this.ipAddressAsBytes;
    }

    private static byte[] deriveIpAddressBytesByString(String ipAddress) {
        try {
            return InetAddress.getByName(ipAddress).getAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private InetAddress deriveInetAddressFromBytes(byte[] ipAddressAsBytes) {
        try {
            return InetAddress.getByAddress(ipAddressAsBytes);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private static InetAddress deriveInetAddressFromString(String ipAddress) {
        try {
            return InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] marshalled() {
        return this.marshalled;
    }

    private static byte[] marshall(String name, byte[] ipAddressAsBytes, int port) {
        byte[] nameAsBytes = name.getBytes();
        return ByteBuffer.allocate(8 + nameAsBytes.length).put(nameAsBytes).put(ipAddressAsBytes).putInt(port).array();
    }

    public static SpeedyHost unmarshall(byte[] message) {
        ByteBuffer wrapped = ByteBuffer.wrap(message);
        int nameLength = message.length - 8;
        byte[] nameAsBytes = new byte[nameLength];
        wrapped.get(nameAsBytes, 0, nameLength);
        byte[] ipAddressBytes = new byte[4];
        wrapped.get(ipAddressBytes, 0, 4);
        int port = wrapped.getInt();
        return new SpeedyHost(new String(nameAsBytes), ipAddressBytes, port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpeedyHost that = (SpeedyHost)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return Arrays.equals(this.ipAddressAsBytes, that.ipAddressAsBytes);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.ipAddressAsBytes);
        result = 31 * result + this.port;
        return result;
    }

    public SocketAddress getSocketAddress() {
        return this.inetSocketAddress;
    }

    public String toString() {
        return "SpeedyHost{name='" + this.name + '\'' + ", port=" + this.port + ", inetAddress=" + this.inetAddress + '}';
    }
}

