/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.benchmark;

import io.kiw.speedy.SpeedyHost;
import io.kiw.speedy.SpeedyMessagingImpl;
import io.kiw.speedy.builder.SpeedyChannel;
import io.kiw.speedy.builder.SpeedyNetwork;
import io.kiw.speedy.builder.SpeedyNetworkBuilder;
import io.kiw.speedy.wiring.StubRouter;
import java.util.concurrent.TimeUnit;

public class SpeedyMessagingThroughputBenchMark {
    public static final int messagesCount = 100000000;
    public static final int WINDOW_SIZE = 32768;
    public static final String KEY = "ping";
    private static byte[] bytes = new byte[40];

    public static void main(String[] args) throws InterruptedException {
        SpeedyHost pubHost = new SpeedyHost("pub", "127.0.0.1", 9000);
        SpeedyHost subHost = new SpeedyHost("sub", "127.0.0.1", 9001);
        StubRouter stubRouter = new StubRouter();
        SpeedyNetwork speedyNetwork = new SpeedyNetworkBuilder().defaultWindowSize(32768).addChannel(SpeedyChannel.newChannel(KEY).withPublishers(pubHost).forKeys(KEY).toSubscribers(subHost)).buildNetwork();
        SpeedyMessagingImpl pub = speedyNetwork.createInstanceBuilderFromPerspective(pubHost).build();
        pub.start();
        stubRouter.start();
        System.out.println("Connected");
        for (int i = 0; i < 1000; ++i) {
            SpeedyMessagingThroughputBenchMark.runBenchMark(pub);
        }
    }

    private static void runBenchMark(SpeedyMessagingImpl pub) {
        long startTime = System.nanoTime();
        for (int i = 0; i < 100000000; ++i) {
            pub.publish(KEY, bytes);
        }
        long endTime = System.nanoTime();
        SpeedyMessagingThroughputBenchMark.outTimes(endTime - startTime);
    }

    private static void outTimes(long timeTaken) {
        long timeTakenPerMessageAvg = timeTaken / 100000000L;
        long msgsPerSecond = TimeUnit.SECONDS.toNanos(1L) / timeTakenPerMessageAvg;
        System.out.println("published 100000000 messages in " + timeTaken + "ns. That's an average of " + timeTakenPerMessageAvg + "ns a message which is " + msgsPerSecond + "msg/s");
    }
}

