/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.benchmark;

import io.kiw.speedy.SpeedyHost;
import io.kiw.speedy.SpeedyMessagingImpl;
import io.kiw.speedy.builder.SpeedyChannel;
import io.kiw.speedy.builder.SpeedyNetwork;
import io.kiw.speedy.builder.SpeedyNetworkBuilder;
import io.kiw.speedy.parallel.ParallelHelper;
import io.kiw.speedy.wiring.StubRouter;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class SpeedyMessagingpingBenchMark {
    public static final int ITERATIONS = 100000;
    public static final int WINDOW_SIZE = 65536;

    public static void main(String[] args) throws InterruptedException {
        SpeedyHost pubHost = new SpeedyHost("pub", "127.0.0.1", 9000);
        SpeedyHost subHost = new SpeedyHost("sub", "127.0.0.1", 9001);
        StubRouter stubRouter = new StubRouter();
        SpeedyNetwork speedyNetwork = new SpeedyNetworkBuilder().defaultWindowSize(65536).addChannel(SpeedyChannel.newChannel("ping").withPublishers(pubHost).forKeys("ping").toSubscribers(subHost)).addChannel(SpeedyChannel.newChannel("pong").withPublishers(subHost).forKeys("pong").toSubscribers(pubHost)).buildNetwork();
        SpeedyMessagingImpl pub = speedyNetwork.createInstanceBuilderFromPerspective(pubHost).build();
        SpeedyMessagingImpl sub = speedyNetwork.createInstanceBuilderFromPerspective(subHost).build();
        byte[] subscriberBytes = new byte[12];
        sub.subscribe("ping", m -> {
            m.get(subscriberBytes);
            sub.publish("pong", subscriberBytes);
        });
        long[] times = new long[100000];
        pub.subscribe("pong", m -> {
            long pingTime = m.getLong();
            int index = m.getInt();
            SpeedyMessagingpingBenchMark.populate(times, pingTime, index);
        });
        byte[] publisherBytes = new byte[12];
        Runnable[] runnableArray = new Runnable[2];
        runnableArray[0] = pub::start;
        runnableArray[1] = sub::start;
        ParallelHelper.parallel(runnableArray);
        stubRouter.start();
        System.out.println("Connected");
        for (int i = 0; i < 100; ++i) {
            SpeedyMessagingpingBenchMark.runBenchmark(pub, times, publisherBytes, ByteBuffer.wrap(publisherBytes));
        }
    }

    private static void clearTimes(long[] times) {
        for (int i = 0; i < times.length; ++i) {
            times[i] = 0L;
        }
    }

    public static void runBenchmark(SpeedyMessagingImpl pub, long[] times, byte[] publisherBytes, ByteBuffer wrap) throws InterruptedException {
        AtomicInteger count = new AtomicInteger(0);
        for (int i = 0; i < 100000; ++i) {
            if (i % 10 == 0) {
                Thread.sleep(1L);
            }
            SpeedyMessagingpingBenchMark.echo(pub, count, publisherBytes, wrap);
        }
        Arrays.sort(times);
        Long twoNines = times[(int)((double)times.length * 0.99)] / 1000L;
        Long threeNines = times[(int)((double)times.length * 0.999)] / 1000L;
        Long fourNines = times[(int)((double)times.length * 0.9999)] / 1000L;
        Long max = times[times.length - 1] / 1000L;
        long sum = Arrays.stream(times).reduce((aLong, aLong2) -> aLong + aLong2).getAsLong();
        long mean = sum / (long)times.length / 1000L;
        System.out.println("two nines:  " + twoNines + "us");
        System.out.println("three nines:  " + threeNines + "us");
        System.out.println("four nines:  " + fourNines + "us");
        System.out.println("max:  " + max + "us");
        System.out.println("mean: " + mean + "us");
        System.out.println("");
        System.out.println("");
        SpeedyMessagingpingBenchMark.clearTimes(times);
    }

    private static void echo(SpeedyMessagingImpl pub, AtomicInteger count, byte[] publisherBytes, ByteBuffer asByteBuffer) {
        long pingTime = System.nanoTime();
        int index = count.getAndIncrement();
        asByteBuffer.putLong(pingTime);
        asByteBuffer.putInt(index);
        asByteBuffer.flip();
        pub.publish("ping", publisherBytes);
    }

    private static void populate(long[] times, long pingTime, int index) {
        long echoTimeNanos;
        long pongTime = System.nanoTime();
        times[index] = echoTimeNanos = pongTime - pingTime;
    }
}

