/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.builder;

import io.kiw.speedy.builder.BuilderValidation;
import java.util.Optional;

public class ChannelOptions {
    private Optional<Integer> windowSize = Optional.empty();
    private int threadCount = 1;

    public static ChannelOptions defaultOptions() {
        return new ChannelOptions();
    }

    public ChannelOptions withWindowSize(int windowSize) {
        BuilderValidation.validateWindowSize(windowSize);
        this.windowSize = Optional.of(windowSize);
        return this;
    }

    public ChannelOptions withSubscriberThreads(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    private ChannelOptions() {
    }

    Optional<Integer> getWindowSize() {
        return this.windowSize;
    }

    int getSubscriberThreadCount() {
        return this.threadCount;
    }
}

