/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.builder;

import io.kiw.speedy.SpeedyHost;
import io.kiw.speedy.builder.SpeedyChannel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class KeysBuilder {
    public static final String RESPONSE_SUFFIX = "-RESPONSE-KEY-SPM";

    public static Set<String> buildAllKeysIncludingResponseKeysToPublishers(SpeedyChannel speedyChannel, String channelName) {
        HashSet<String> allKeysIncludingResponseKeys = new HashSet<String>(speedyChannel.keys);
        for (SpeedyHost subscriberHost : speedyChannel.publisherHosts) {
            String remoteHostKey = KeysBuilder.buildResponseKey(subscriberHost, channelName);
            allKeysIncludingResponseKeys.add(remoteHostKey);
        }
        return allKeysIncludingResponseKeys;
    }

    public static String buildResponseKey(SpeedyHost host, String channelName) {
        return channelName.hashCode() + "-" + host.hashCode() + RESPONSE_SUFFIX;
    }

    public static Set<String> buildAllKeysAndMyResponseKeyForSubscribing(SpeedyChannel speedyChannel, String channelName, SpeedyHost perspectiveHost) {
        HashSet<String> keysWithLocalResponseKey = new HashSet<String>(speedyChannel.keys);
        keysWithLocalResponseKey.add(KeysBuilder.buildResponseKey(perspectiveHost, channelName));
        return keysWithLocalResponseKey;
    }

    public static Collection<String> buildKeysForOnlyResponseForSubscribing(SpeedyHost perspectiveHost, String channelName) {
        HashSet<String> onlyResponse = new HashSet<String>();
        onlyResponse.add(KeysBuilder.buildResponseKey(perspectiveHost, channelName));
        return onlyResponse;
    }

    public static Set<String> buildResponseKeysToPublishers(SpeedyChannel speedyChannel, String channelName) {
        HashSet<String> remoteHostResponseKeys = new HashSet<String>();
        for (SpeedyHost publisherHost : speedyChannel.publisherHosts) {
            String remoteHostKey = KeysBuilder.buildResponseKey(publisherHost, channelName);
            remoteHostResponseKeys.add(remoteHostKey);
        }
        return remoteHostResponseKeys;
    }
}

