/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.builder;

import io.kiw.speedy.SpeedyHost;
import io.kiw.speedy.builder.ChannelMode;
import io.kiw.speedy.builder.ChannelOptions;
import io.kiw.speedy.builder.KeysBuilder;
import io.kiw.speedy.builder.PublishingChannel;
import io.kiw.speedy.builder.SpeedyChannel;
import io.kiw.speedy.builder.SpeedyMessagingBuilder;
import io.kiw.speedy.builder.SubscribingChannel;
import io.kiw.speedy.management.ManagementKey;
import io.kiw.speedy.subscriber.ManagementSubscriptions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpeedyNetwork {
    public static final int MANAGEMENT_ROUTE_WINDOW_SIZE = 256;
    private final List<SpeedyChannel> speedyChannels;
    private final int defaultWindowSize;

    public SpeedyNetwork(List<SpeedyChannel> speedyChannels, int defaultWindowSize) {
        this.speedyChannels = speedyChannels;
        this.defaultWindowSize = defaultWindowSize;
    }

    public SpeedyMessagingBuilder createInstanceBuilderFromPerspective(SpeedyHost perspectiveHost) {
        HashMap<Integer, PublishingChannel> publishingChannels = new HashMap<Integer, PublishingChannel>();
        HashMap<Integer, SubscribingChannel> subscribingChannels = new HashMap<Integer, SubscribingChannel>();
        HashSet<SpeedyHost> remoteHosts = new HashSet<SpeedyHost>();
        for (SpeedyChannel speedyChannel : this.speedyChannels) {
            String channelName = speedyChannel.channelName;
            ChannelOptions channelOptions = speedyChannel.getChannelOptions();
            int windowSizeOfChannel = channelOptions.getWindowSize().isPresent() ? channelOptions.getWindowSize().get() : this.defaultWindowSize;
            int subscriberThreads = channelOptions.getSubscriberThreadCount();
            if (this.iAmAPublisherAndASubscriberOnThisChannel(perspectiveHost, speedyChannel)) {
                remoteHosts.addAll(speedyChannel.subscriberHosts);
                remoteHosts.addAll(speedyChannel.publisherHosts);
                Set<String> allKeysIncludingResponseKeys = KeysBuilder.buildAllKeysIncludingResponseKeysToPublishers(speedyChannel, channelName);
                publishingChannels.put(channelName.hashCode(), new PublishingChannel(allKeysIncludingResponseKeys, speedyChannel.subscriberHosts, windowSizeOfChannel, ChannelMode.DUPLEX));
                Set<String> keysWithLocalResponseKey = KeysBuilder.buildAllKeysAndMyResponseKeyForSubscribing(speedyChannel, channelName, perspectiveHost);
                subscribingChannels.put(channelName.hashCode(), new SubscribingChannel(keysWithLocalResponseKey, speedyChannel.publisherHosts, windowSizeOfChannel, channelName, subscriberThreads));
                continue;
            }
            if (this.iAmAPublisherOnlyOnThisChannel(perspectiveHost, speedyChannel)) {
                remoteHosts.addAll(speedyChannel.subscriberHosts);
                publishingChannels.put(channelName.hashCode(), new PublishingChannel(speedyChannel.keys, speedyChannel.subscriberHosts, windowSizeOfChannel, ChannelMode.PUBLISHER_ONLY));
                subscribingChannels.put(channelName.hashCode(), new SubscribingChannel(KeysBuilder.buildKeysForOnlyResponseForSubscribing(perspectiveHost, channelName), speedyChannel.subscriberHosts, windowSizeOfChannel, channelName, subscriberThreads));
                continue;
            }
            if (!this.iAmASubscriberOnlyOnThisChannel(perspectiveHost, speedyChannel)) continue;
            remoteHosts.addAll(speedyChannel.publisherHosts);
            Set<String> remoteHostResponseKeys = KeysBuilder.buildResponseKeysToPublishers(speedyChannel, channelName);
            publishingChannels.put(channelName.hashCode(), new PublishingChannel(remoteHostResponseKeys, speedyChannel.publisherHosts, windowSizeOfChannel, ChannelMode.SUBSCRIBER_ONLY));
            subscribingChannels.put(channelName.hashCode(), new SubscribingChannel(speedyChannel.keys, speedyChannel.publisherHosts, windowSizeOfChannel, channelName, subscriberThreads));
        }
        this.registerManagementChannel(perspectiveHost, publishingChannels, subscribingChannels, remoteHosts);
        return new SpeedyMessagingBuilder(perspectiveHost, publishingChannels, subscribingChannels, remoteHosts);
    }

    private boolean iAmASubscriberOnlyOnThisChannel(SpeedyHost perspectiveHost, SpeedyChannel speedyChannel) {
        return !speedyChannel.publisherHosts.contains(perspectiveHost) && speedyChannel.subscriberHosts.contains(perspectiveHost);
    }

    private boolean iAmAPublisherOnlyOnThisChannel(SpeedyHost perspectiveHost, SpeedyChannel speedyChannel) {
        return speedyChannel.publisherHosts.contains(perspectiveHost) && !speedyChannel.subscriberHosts.contains(perspectiveHost);
    }

    private boolean iAmAPublisherAndASubscriberOnThisChannel(SpeedyHost perspectiveHost, SpeedyChannel speedyChannel) {
        return speedyChannel.publisherHosts.contains(perspectiveHost) && speedyChannel.subscriberHosts.contains(perspectiveHost);
    }

    private void registerManagementChannel(SpeedyHost perspectiveHost, Map<Integer, PublishingChannel> publishingChannels, Map<Integer, SubscribingChannel> subscribingChannels, Set<SpeedyHost> remoteHosts) {
        Set<String> allStaticManagentKeys = ManagementKey.MANAGEMENT_KEY_SET;
        HashSet<String> allManagementSubscriptionKeys = new HashSet<String>(allStaticManagentKeys);
        allManagementSubscriptionKeys.add(KeysBuilder.buildResponseKey(perspectiveHost, ManagementSubscriptions.getChannelName()));
        HashSet<String> allManagementPublisherKeys = new HashSet<String>(allStaticManagentKeys);
        for (SpeedyHost remoteHost : remoteHosts) {
            allManagementPublisherKeys.add(KeysBuilder.buildResponseKey(remoteHost, ManagementSubscriptions.getChannelName()));
        }
        publishingChannels.put(ManagementSubscriptions.getChannelName().hashCode(), new PublishingChannel(allManagementPublisherKeys, remoteHosts, 256, ChannelMode.DUPLEX));
        subscribingChannels.put(ManagementSubscriptions.getChannelName().hashCode(), new SubscribingChannel(allManagementSubscriptionKeys, remoteHosts, 256, ManagementSubscriptions.getChannelName(), 1));
    }
}

