/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.builder;

import io.kiw.speedy.SpeedyHost;
import io.kiw.speedy.builder.BuilderValidation;
import io.kiw.speedy.builder.SpeedyChannel;
import io.kiw.speedy.builder.SpeedyNetwork;
import io.kiw.speedy.exception.ConflictingRouteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SpeedyNetworkBuilder {
    private final List<SpeedyChannel> speedyChannels = new ArrayList<SpeedyChannel>();
    private int defaultWindowSize = 65536;

    public SpeedyNetwork buildNetwork() {
        return new SpeedyNetwork(this.speedyChannels, this.defaultWindowSize);
    }

    public SpeedyNetworkBuilder defaultWindowSize(int windowSize) {
        BuilderValidation.validateWindowSize(windowSize);
        this.defaultWindowSize = windowSize;
        return this;
    }

    public SpeedyNetworkBuilder addChannel(SpeedyChannel newRoute) {
        for (SpeedyChannel existingRoute : this.speedyChannels) {
            Set<SpeedyHost> duplicatePublishers = this.getDuplicates(newRoute.publisherHosts, existingRoute.publisherHosts);
            Set<SpeedyHost> duplicateSubscribers = this.getDuplicates(newRoute.subscriberHosts, existingRoute.subscriberHosts);
            Set<String> duplicateKeys = this.getDuplicates(newRoute.keys, existingRoute.keys);
            if (duplicatePublishers.size() <= 0 || duplicateKeys.size() <= 0 || duplicateSubscribers.size() <= 0) continue;
            throw new ConflictingRouteException("Route conflict found for new route:\n" + newRoute + " \nagainst:\n" + existingRoute);
        }
        this.speedyChannels.add(newRoute);
        return this;
    }

    private <T> Set<T> getDuplicates(Collection<T> collectionOne, Collection<T> collectionTwo) {
        HashSet<T> setOne = new HashSet<T>(collectionOne);
        HashSet<T> setTwo = new HashSet<T>(collectionTwo);
        HashSet<T> remainingSet = new HashSet<T>(setOne);
        remainingSet.retainAll(setTwo);
        return remainingSet;
    }
}

