/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.channel;

import io.kiw.speedy.channel.NackTask;
import io.kiw.speedy.helper.ImmutableLongMap;

public class NackSchedulerJob {
    private final ImmutableLongMap<NackTask> nackTasks;

    public NackSchedulerJob(ImmutableLongMap<NackTask> nackTasks) {
        this.nackTasks = nackTasks;
    }

    public void onNack(int channelIdentifier, int publisherIdentifier, long firstMissingSequenceNumber, long lastMissingSequenceNumber) {
        long key = (long)channelIdentifier + (long)publisherIdentifier;
        NackTask nackTask = this.nackTasks.get(key);
        if (nackTask != null) {
            nackTask.handleNack(firstMissingSequenceNumber, lastMissingSequenceNumber);
        }
    }

    public void onPulse(long nanoTime) {
        for (NackTask nackTask : this.nackTasks.values()) {
            nackTask.onPulse(nanoTime);
        }
    }
}

