/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.channel;

import io.kiw.speedy.channel.NackMarshaller;
import io.kiw.speedy.management.ManagementKey;
import io.kiw.speedy.publisher.PublishPromise;
import java.util.concurrent.TimeUnit;

public class NackTask {
    public static final long NACK_TIMEOUT = TimeUnit.MILLISECONDS.toNanos(50L);
    private final NackMarshaller nackMarshaller = new NackMarshaller();
    private final PublishPromise publishPromise;
    private final int publisherIdentifier;
    private final int channelIdentifier;
    private long lastSentNack = 0L;
    private volatile boolean inProgress = false;
    private long firstMissingSequenceNumber;
    private long lastMissingSequenceNumber;

    public NackTask(PublishPromise publishPromise, int publisherIdentifier, int channelIdentifier) {
        this.publishPromise = publishPromise;
        this.publisherIdentifier = publisherIdentifier;
        this.channelIdentifier = channelIdentifier;
    }

    public void handleNack(long firstMissingSequenceNumber, long lastMissingSequenceNumber) {
        if (!this.inProgress) {
            this.firstMissingSequenceNumber = firstMissingSequenceNumber;
            this.lastMissingSequenceNumber = lastMissingSequenceNumber;
            this.inProgress = true;
        }
    }

    public void onPulse(long nanoTime) {
        if (this.inProgress && this.lastSentNack + NACK_TIMEOUT < nanoTime) {
            System.out.println("SUBSCRIBER: NACKED requesting resend on channel " + this.channelIdentifier + " for " + this.firstMissingSequenceNumber + " to " + this.lastMissingSequenceNumber);
            this.lastSentNack = nanoTime;
            this.publishPromise.publish(ManagementKey.NACK.getKey(), this.nackMarshaller.marshall(this.publisherIdentifier, this.channelIdentifier, this.firstMissingSequenceNumber, this.lastMissingSequenceNumber));
            this.inProgress = false;
        }
    }
}

