/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.channel;

import io.kiw.speedy.channel.RecoveryBuffer;
import java.nio.ByteBuffer;

public class PublisherSequenceState {
    private final RecoveryBuffer recoveryBuffer;
    private final int localhostIdentifier;
    private final int channelIdentifier;
    private long packetSequenceNumber = 0L;
    private long eventSequenceNumber = 0L;

    private PublisherSequenceState(int windowSize, int localhostIdentifier, int channelIdentifier) {
        this.recoveryBuffer = new RecoveryBuffer(windowSize);
        this.localhostIdentifier = localhostIdentifier;
        this.channelIdentifier = channelIdentifier;
    }

    public static PublisherSequenceState initialise(int windowSize, int localhostIdentifier, int channelIdentifier) {
        PublisherSequenceState publisherSequenceState = new PublisherSequenceState(windowSize, localhostIdentifier, channelIdentifier);
        publisherSequenceState.preparePacket(publisherSequenceState.packetSequenceNumber);
        return publisherSequenceState;
    }

    public long getPacketSequenceNumber() {
        return this.packetSequenceNumber;
    }

    public ByteBuffer getMessage(long i) {
        return this.recoveryBuffer.getPacket(i);
    }

    public long getAndIncrementEventSequenceNumber() {
        return this.eventSequenceNumber++;
    }

    public ByteBuffer getCurrentPublisherBuffer() {
        return this.getMessage(this.getPacketSequenceNumber());
    }

    public void incrementAndMarshallNextPacketHeader() {
        this.preparePacket(++this.packetSequenceNumber);
    }

    private void preparePacket(long packetSequenceNumber) {
        ByteBuffer packet = this.recoveryBuffer.getPacket(packetSequenceNumber);
        packet.clear();
        packet.putLong(packetSequenceNumber);
        packet.putInt(this.localhostIdentifier);
        packet.putInt(this.channelIdentifier);
    }
}

