/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.channel;

import java.nio.ByteBuffer;

public class RecoveryBuffer {
    private final ByteBuffer[] buffers;
    private final int limit;

    public RecoveryBuffer(int windowSize) {
        this.limit = windowSize - 1;
        this.buffers = RecoveryBuffer.createByteBuffers(windowSize);
    }

    public void addMessageToPacketRecoveryBuffer(long sequenceNumberOfPacket, ByteBuffer packetBuffer) {
        ByteBuffer bufferFromRecovery = this.buffers[this.getBufferIndex(sequenceNumberOfPacket)];
        bufferFromRecovery.clear();
        bufferFromRecovery.put(packetBuffer);
        bufferFromRecovery.flip();
    }

    public ByteBuffer getPacket(long sequenceNumber) {
        return this.buffers[this.getBufferIndex(sequenceNumber)];
    }

    public void markSeen(long sequenceNumberOfPacket) {
        ByteBuffer buffer = this.buffers[this.getBufferIndex(sequenceNumberOfPacket)];
        buffer.clear();
        buffer.position(5920);
    }

    private int getBufferIndex(long sequenceNumberOfPacket) {
        return (int)(sequenceNumberOfPacket & (long)this.limit);
    }

    private static ByteBuffer[] createByteBuffers(int windowSize) {
        ByteBuffer[] byteBuffers = new ByteBuffer[windowSize];
        for (int i = 0; i < windowSize; ++i) {
            ByteBuffer allocate = ByteBuffer.allocateDirect(5920);
            allocate.position(5920);
            byteBuffers[i] = allocate;
        }
        return byteBuffers;
    }
}

