/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.channel;

import io.kiw.speedy.channel.MultiResponseHandler;
import io.kiw.speedy.channel.TemporaryResponseHandler;
import io.kiw.speedy.subscriber.SpeedyMessageHandler;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TemporaryResponseHandlerImpl
implements TemporaryResponseHandler {
    private final ConcurrentMap<Long, MultiResponseHandler> responseHandlers = new ConcurrentHashMap<Long, MultiResponseHandler>();
    private final String responseKey;

    public TemporaryResponseHandlerImpl(String responseKey) {
        this.responseKey = responseKey;
    }

    @Override
    public void add(long sequenceNumber, SpeedyMessageHandler responseHandler, int expectedResponses) {
        this.responseHandlers.putIfAbsent(sequenceNumber, new MultiResponseHandler(responseHandler, expectedResponses));
    }

    @Override
    public void handle(ByteBuffer message) {
        long originalRequestSequence = message.getLong();
        MultiResponseHandler multiResponseHandler = (MultiResponseHandler)this.responseHandlers.get(originalRequestSequence);
        if (multiResponseHandler.handleMessageAndGetRemainingExpectedResponseCount(message)) {
            this.responseHandlers.remove(originalRequestSequence);
        }
    }

    @Override
    public String getResponseKey() {
        return this.responseKey;
    }
}

