/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class ImmutableLongMap<T> {
    private final T[] underlyingArray;
    private final int mask;
    private final int size;
    private final Set<Long> keySet;
    private final Collection<T> values;

    ImmutableLongMap(T[] underlyingArray, Set<Long> keySet, Collection<T> values) {
        this.mask = underlyingArray.length - 1;
        this.underlyingArray = underlyingArray;
        this.keySet = Collections.unmodifiableSet(keySet);
        this.values = Collections.unmodifiableCollection(values);
        this.size = values.size();
    }

    public T get(long index) {
        return this.underlyingArray[(int)(index & (long)this.mask)];
    }

    public Collection<T> values() {
        return this.values;
    }

    public boolean containsKey(long index) {
        return this.get(index) == null;
    }

    public int size() {
        return this.size;
    }

    public Set<Long> keySet() {
        return this.keySet;
    }
}

