/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.helper;

import io.kiw.speedy.helper.ImmutableIntMap;
import io.kiw.speedy.helper.ImmutableLongMap;
import java.util.Map;

public class ImmutableMapFactory {
    public static <T> ImmutableIntMap<T> initialiseIntMap(Map<Integer, T> integerMap) {
        T[] underlyingArray;
        InitalisationState initalisationState = new InitalisationState();
        block0: do {
            underlyingArray = initalisationState.buildUnderlyingArray();
            int mask = initalisationState.getMask();
            for (Map.Entry<Integer, T> entry : integerMap.entrySet()) {
                if (underlyingArray[entry.getKey() & mask] != null) {
                    initalisationState.seenCollision = true;
                    continue block0;
                }
                underlyingArray[entry.getKey().intValue() & mask] = entry.getValue();
            }
        } while (initalisationState.seenCollisionAndDoubleUp());
        return new ImmutableIntMap(underlyingArray, integerMap.keySet(), integerMap.values());
    }

    public static <T> ImmutableLongMap<T> initialiseLongMap(Map<Long, T> longMap) {
        T[] underlyingArray;
        InitalisationState initalisationState = new InitalisationState();
        block0: do {
            underlyingArray = initalisationState.buildUnderlyingArray();
            int mask = initalisationState.getMask();
            for (Map.Entry<Long, T> entry : longMap.entrySet()) {
                if (underlyingArray[(int)(entry.getKey() & (long)mask)] != null) {
                    initalisationState.seenCollision = true;
                    continue block0;
                }
                underlyingArray[(int)(entry.getKey().longValue() & (long)mask)] = entry.getValue();
            }
        } while (initalisationState.seenCollisionAndDoubleUp());
        return new ImmutableLongMap(underlyingArray, longMap.keySet(), longMap.values());
    }

    private static class InitalisationState<T> {
        int size = 2;
        boolean seenCollision = false;

        private InitalisationState() {
        }

        public boolean seenCollisionAndDoubleUp() {
            boolean seenCollision = this.seenCollision;
            if (seenCollision) {
                this.size *= 2;
                this.seenCollision = false;
            }
            return seenCollision;
        }

        public int getMask() {
            return this.size - 1;
        }

        public T[] buildUnderlyingArray() {
            return new Object[this.size];
        }
    }
}

