/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.marshaller;

import io.kiw.speedy.SpeedyConnection;
import io.kiw.speedy.channel.PublisherSequenceState;
import io.kiw.speedy.marshaller.MessageMarshaller;
import io.kiw.speedy.publisher.PacketFlusher;
import java.nio.ByteBuffer;

public class EventMarshaller {
    private final PacketFlusher packetflusher;

    public EventMarshaller(PacketFlusher packetflusher) {
        this.packetflusher = packetflusher;
    }

    public void push(String key, byte[] eventIntBytes, int eventLength, PublisherSequenceState packetSequenceState, long eventSequenceNumber, SpeedyConnection[] connectionsToPublishTo, boolean isManagementKey) {
        int packetsToSendCount = (8 + eventLength + 5895) / 5896;
        int remainingEventDataLength = eventLength;
        int offset = 0;
        ByteBuffer currentPublisherBuffer = packetSequenceState.getCurrentPublisherBuffer();
        for (int i = 0; i < packetsToSendCount; ++i) {
            int maxEventDataSizeInThisPacket;
            int eventHeaderSize;
            boolean firstPacket = offset == 0;
            int n = eventHeaderSize = firstPacket ? 8 : 0;
            if (currentPublisherBuffer.remaining() != 5904 && eventHeaderSize + remainingEventDataLength + 8 > currentPublisherBuffer.remaining()) {
                this.packetflusher.flushNewMessage(currentPublisherBuffer, connectionsToPublishTo, packetSequenceState);
                currentPublisherBuffer = packetSequenceState.getCurrentPublisherBuffer();
            }
            int writeLength = remainingEventDataLength < (maxEventDataSizeInThisPacket = 5896 - eventHeaderSize) ? remainingEventDataLength : maxEventDataSizeInThisPacket;
            MessageMarshaller.marshallIndividualMessage(key, eventIntBytes, offset, writeLength, remainingEventDataLength, currentPublisherBuffer, firstPacket, eventSequenceNumber);
            remainingEventDataLength -= writeLength;
            offset += writeLength;
            if (!isManagementKey) continue;
            this.packetflusher.flushNewMessage(currentPublisherBuffer, connectionsToPublishTo, packetSequenceState);
        }
    }
}

