/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.publisher;

import io.kiw.speedy.SpeedyConnection;
import io.kiw.speedy.channel.PublisherSequenceState;
import io.kiw.speedy.publisher.PacketSender;
import java.nio.ByteBuffer;

public class PacketFlusher {
    private final PacketSender packetSender;

    public PacketFlusher(PacketSender packetSender) {
        this.packetSender = packetSender;
    }

    public void flushNewMessage(ByteBuffer packetBuffer, SpeedyConnection[] connectionsToPublishTo, PublisherSequenceState packetSequenceState) {
        for (SpeedyConnection remoteConnection : connectionsToPublishTo) {
            packetBuffer.flip();
            this.packetSender.sendPacket(packetBuffer, remoteConnection.getHost());
        }
        packetSequenceState.incrementAndMarshallNextPacketHeader();
    }

    public void flushResendMessage(ByteBuffer packetBuffer, SpeedyConnection[] connectionsToPublishTo) {
        for (SpeedyConnection remoteConnection : connectionsToPublishTo) {
            packetBuffer.flip();
            this.packetSender.sendPacket(packetBuffer, remoteConnection.getHost());
        }
    }
}

