/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.publisher;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;

public class SchedulerThread {
    public static final int WAIT_TO_CHECK_TIME = 10000;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "Scheduler-Thread"));
    private final List<ScheduledJob> scheduledJobs = new ArrayList<ScheduledJob>();
    private final LongSupplier nanoTimeRetriever;
    private boolean started;

    public SchedulerThread(LongSupplier nanoTimeRetriever) {
        this.nanoTimeRetriever = nanoTimeRetriever;
    }

    public void addJob(ScheduledJob scheduledJob) {
        if (this.started) {
            throw new RuntimeException("Can't add a new job while already started");
        }
        this.scheduledJobs.add(scheduledJob);
    }

    public void start() {
        this.started = true;
        this.scheduledExecutorService.scheduleWithFixedDelay(this::pulse, 10000L, 10000L, TimeUnit.NANOSECONDS);
    }

    public void pulse() {
        long nanoTime = this.nanoTimeRetriever.getAsLong();
        this.scheduledJobs.forEach(j -> j.run(nanoTime));
    }

    public void stop() {
        this.scheduledExecutorService.shutdown();
    }

    public static class ScheduledJob {
        private final long interval;
        private long lastRunTime;
        private final LongConsumer consumer;

        public ScheduledJob(long interval, long lastRunTime, LongConsumer consumer) {
            this.interval = interval;
            this.lastRunTime = lastRunTime;
            this.consumer = consumer;
        }

        public void run(long currentTime) {
            if (currentTime > this.lastRunTime + this.interval) {
                this.consumer.accept(currentTime);
                this.lastRunTime = currentTime;
            }
        }
    }
}

