/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.subscriber;

import io.kiw.speedy.publisher.PublishPromise;
import io.kiw.speedy.subscriber.Responder;
import io.kiw.speedy.subscriber.SpeedyMessageHandler;
import io.kiw.speedy.subscriber.SpeedyMessageReplyHandler;
import java.nio.ByteBuffer;

public class GenericHandler {
    private final SpeedyMessageReplyHandler speedyMessageReplyHandler;
    private final ResponderPrimer responderPrimer;

    public GenericHandler(SpeedyMessageHandler speedyMessageHandler) {
        this.speedyMessageReplyHandler = GenericHandler.convertHandler(speedyMessageHandler);
        this.responderPrimer = GenericHandler::noOp;
    }

    public GenericHandler(SpeedyMessageReplyHandler speedyMessageHandler) {
        this.speedyMessageReplyHandler = speedyMessageHandler;
        this.responderPrimer = GenericHandler::setUpResponder;
    }

    public void handleMessage(ByteBuffer eventBuffer, Responder responder, int publisherIdentifier, long eventSequenceNumber, PublishPromise publishPromise) {
        this.responderPrimer.primeResponder(responder, publisherIdentifier, eventSequenceNumber, publishPromise);
        this.speedyMessageReplyHandler.handleMessage(eventBuffer, responder);
    }

    private static SpeedyMessageReplyHandler convertHandler(SpeedyMessageHandler speedyMessageHandler) {
        return (applicationData, responder) -> speedyMessageHandler.handleMessage(applicationData);
    }

    private static Responder setUpResponder(Responder responder, int publisherIdentifier, long eventSequenceNumber, PublishPromise publishPromise) {
        return responder.setAndGet(publisherIdentifier, eventSequenceNumber, publishPromise);
    }

    private static Responder noOp(Responder responder, int publisherIdentifier, long eventSequenceNumber, PublishPromise publishPromise) {
        return responder;
    }

    private static interface ResponderPrimer {
        public Responder primeResponder(Responder var1, int var2, long var3, PublishPromise var5);
    }
}

