/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.subscriber;

import io.kiw.speedy.publisher.PublishPromise;
import io.kiw.speedy.subscriber.GenericHandler;
import io.kiw.speedy.subscriber.Responder;
import java.nio.ByteBuffer;

public class HandleMessageEvent {
    private GenericHandler speedyMessageHandler;
    private int publisherIdentifier;
    private long eventSequenceNumber;
    private PublishPromise publishPromise;
    private final byte[] data = new byte[754688];
    private int dataLength;

    public HandleMessageEvent overwrite(HandleMessageEvent instanceToReplaceWith) {
        this.speedyMessageHandler = instanceToReplaceWith.speedyMessageHandler;
        System.arraycopy(instanceToReplaceWith.data, 0, this.data, 0, instanceToReplaceWith.dataLength);
        this.dataLength = instanceToReplaceWith.dataLength;
        this.publisherIdentifier = instanceToReplaceWith.publisherIdentifier;
        this.eventSequenceNumber = instanceToReplaceWith.eventSequenceNumber;
        this.publishPromise = instanceToReplaceWith.publishPromise;
        return this;
    }

    public void handle(Responder responder, ByteBuffer eventBuffer) {
        eventBuffer.clear();
        eventBuffer.put(this.data, 0, this.dataLength);
        eventBuffer.flip();
        this.speedyMessageHandler.handleMessage(eventBuffer, responder.setAndGet(this.publisherIdentifier, this.eventSequenceNumber, this.publishPromise), this.publisherIdentifier, this.eventSequenceNumber, this.publishPromise);
    }

    public void overwrite(GenericHandler speedyMessageHandler, ByteBuffer eventBuffer, int publisherIdentifier, long eventSequenceNumber, PublishPromise publishPromise) {
        this.speedyMessageHandler = speedyMessageHandler;
        eventBuffer.get(this.data, 0, eventBuffer.limit());
        this.dataLength = eventBuffer.position();
        this.publisherIdentifier = publisherIdentifier;
        this.eventSequenceNumber = eventSequenceNumber;
        this.publishPromise = publishPromise;
    }
}

