/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.subscriber;

import io.kiw.speedy.PublisherBucket;
import io.kiw.speedy.SpeedyConnection;
import io.kiw.speedy.SpeedyHost;
import io.kiw.speedy.channel.NackSchedulerJob;
import io.kiw.speedy.exception.InvalidSubscriptionException;
import io.kiw.speedy.helper.ImmutableIntMap;
import io.kiw.speedy.helper.ImmutableMapFactory;
import io.kiw.speedy.marshaller.MessageUnMarshaller;
import io.kiw.speedy.publisher.PublishPromise;
import io.kiw.speedy.publisher.SchedulerThread;
import io.kiw.speedy.subscriber.GenericHandler;
import io.kiw.speedy.subscriber.ManagementSubscriptions;
import io.kiw.speedy.subscriber.NackSchedulerJobFactory;
import io.kiw.speedy.subscriber.OnMessageErrorHandler;
import io.kiw.speedy.subscriber.SpeedyMessagingSubscriber;
import io.kiw.speedy.subscriber.SubscriberChannelState;
import io.kiw.speedy.wiring.SpeedyWiring;
import java.util.HashMap;
import java.util.Map;

public class SpeedyMessagingSubscriberFactory {
    private final SpeedyHost localhost;
    private final MessageUnMarshaller messageUnMarshaller;
    private final ImmutableIntMap<SpeedyConnection> remoteConnections;
    private final PublishPromise publishPromise;
    private final OnMessageErrorHandler subcribeErrorHandler;
    private final SpeedyWiring wiring;
    private final ImmutableIntMap<PublisherBucket> publisherBuckets;
    private final SchedulerThread schedulerThread;
    private final Map<Integer, SubscriberChannelState> channelStates;
    private final Map<Integer, GenericHandler> subscriptions = new HashMap<Integer, GenericHandler>();

    public SpeedyMessagingSubscriberFactory(SpeedyHost localhost, MessageUnMarshaller messageUnMarshaller, ImmutableIntMap<SpeedyConnection> remoteConnections, PublishPromise publishPromise, OnMessageErrorHandler subcribeErrorHandler, SpeedyWiring wiring, ImmutableIntMap<PublisherBucket> publisherBuckets, SchedulerThread schedulerThread, Map<Integer, SubscriberChannelState> channelStates) {
        this.localhost = localhost;
        this.messageUnMarshaller = messageUnMarshaller;
        this.remoteConnections = remoteConnections;
        this.publishPromise = publishPromise;
        this.subcribeErrorHandler = subcribeErrorHandler;
        this.wiring = wiring;
        this.publisherBuckets = publisherBuckets;
        this.schedulerThread = schedulerThread;
        this.channelStates = channelStates;
    }

    public SpeedyMessagingSubscriber build() {
        SpeedyMessagingSubscriberFactory.addManagementHandlers(this.subscriptions, this.localhost, this.remoteConnections, this.publishPromise, this.publisherBuckets);
        NackSchedulerJob nackSchedulerJob = NackSchedulerJobFactory.build(this.publishPromise, this.remoteConnections.keySet(), this.channelStates.keySet());
        return new SpeedyMessagingSubscriber(this.messageUnMarshaller, this.remoteConnections, this.publishPromise, this.subcribeErrorHandler, this.wiring, nackSchedulerJob, this.schedulerThread, ImmutableMapFactory.initialiseIntMap(this.subscriptions));
    }

    public void addSubscriptionHandler(String key, GenericHandler speedyMessageHandler) {
        this.assertSubscriptionKeyHasBeenRegistered(key);
        this.subscriptions.put(key.hashCode(), speedyMessageHandler);
    }

    public void assertAllKeysHaveBeenSubscribedTo() {
        for (SpeedyConnection speedyConnection : this.remoteConnections.values()) {
            speedyConnection.assertAllKeysHaveBeenSubscribedTo(this.subscriptions.keySet());
        }
    }

    private static void addManagementHandlers(Map<Integer, GenericHandler> subscriptions, SpeedyHost localhost, ImmutableIntMap<SpeedyConnection> remoteHosts, PublishPromise publishPromise, ImmutableIntMap<PublisherBucket> publisherBuckets) {
        ManagementSubscriptions.getHostRegistrationSubscription(subscriptions, localhost, remoteHosts, publishPromise);
        ManagementSubscriptions.getHostAcknowledgementSubscription(subscriptions, localhost, remoteHosts);
        ManagementSubscriptions.getNackSubscription(subscriptions, localhost, publishPromise, publisherBuckets);
    }

    private void assertSubscriptionKeyHasBeenRegistered(String key) {
        for (SpeedyConnection speedyConnection : this.remoteConnections.values()) {
            if (!speedyConnection.containsRegistrationToKey(key)) continue;
            return;
        }
        throw new InvalidSubscriptionException(key);
    }
}

