/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.subscriber;

import io.kiw.speedy.channel.RecoveryBuffer;
import io.kiw.speedy.channel.TemporaryResponseHandler;
import io.kiw.speedy.publisher.PublishPromise;
import io.kiw.speedy.subscriber.GenericHandler;
import io.kiw.speedy.subscriber.SpeedyMessageHandler;
import io.kiw.speedy.subscriber.SubscriberThreadHandler;
import java.nio.ByteBuffer;

public class SubscriberChannelState {
    private final SubscriberThreadHandler subscriberThreadHandler;
    private long sequenceNumber;
    private final RecoveryBuffer recoveryBuffer;
    private final ByteBuffer eventBuffer = ByteBuffer.allocateDirect(188672);
    private final TemporaryResponseHandler temporaryResponseHandler;
    private long eventSequenceNumber;

    public SubscriberChannelState(long startingSequenceNumber, int windowSize, SubscriberThreadHandler subscriberThreadHandler, TemporaryResponseHandler temporaryResponseHandler) {
        this.sequenceNumber = startingSequenceNumber;
        this.recoveryBuffer = new RecoveryBuffer(windowSize);
        this.temporaryResponseHandler = temporaryResponseHandler;
        this.subscriberThreadHandler = subscriberThreadHandler;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public ByteBuffer getNextRecoverMessage() {
        return this.recoveryBuffer.getPacket(this.sequenceNumber);
    }

    public void increment(long packetSequenceNumber) {
        this.recoveryBuffer.markSeen(packetSequenceNumber);
        ++this.sequenceNumber;
    }

    public void copyToRecovery(ByteBuffer buffer, long packetSequenceNumber) {
        this.recoveryBuffer.addMessageToPacketRecoveryBuffer(packetSequenceNumber, buffer);
    }

    public ByteBuffer getEventBuffer() {
        return this.eventBuffer;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void handleResponse(ByteBuffer message) {
        this.temporaryResponseHandler.handle(message);
    }

    public String getResponseKey() {
        return this.temporaryResponseHandler.getResponseKey();
    }

    public void addResponseHandler(SpeedyMessageHandler responseHandler, int responseCountToExpect, long eventSequenceNumber) {
        this.temporaryResponseHandler.add(eventSequenceNumber, responseHandler, responseCountToExpect);
    }

    public void setEventSequenceNumber(long eventSequenceNumber) {
        this.eventSequenceNumber = eventSequenceNumber;
    }

    public void handleMessage(GenericHandler speedyMessageHandler, ByteBuffer eventBuffer, int publisherIdentifier, PublishPromise publishPromise) {
        this.subscriberThreadHandler.handleMessage(speedyMessageHandler, eventBuffer, publisherIdentifier, this.eventSequenceNumber, publishPromise);
    }
}

