/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.wiring;

import io.kiw.speedy.SpeedyHost;
import io.kiw.speedy.wiring.EventResponse;
import io.kiw.speedy.wiring.NetworkQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public class StubRouter {
    private int eventId = 0;
    private int completedEventId = 0;
    private boolean started = false;
    private final Map<SpeedyHost, NetworkQueue> networkQueues = new HashMap<SpeedyHost, NetworkQueue>();
    private final List<EventResponse> eventResponseList = new ArrayList<EventResponse>();
    private final Queue<EventResponse> preStartMessages = new ArrayBlockingQueue<EventResponse>(1024);
    private final List<Runnable> pulseHandlers = new ArrayList<Runnable>();
    private boolean droppingPackets = false;
    private long nanoTime = System.nanoTime();

    public void addFragmentHandler(SpeedyHost localHost, Runnable fragmentHandler) {
        this.networkQueues.put(localHost, new NetworkQueue(fragmentHandler));
    }

    public byte[] receive(SpeedyHost localHost) {
        return this.networkQueues.get(localHost).getFragment();
    }

    public void send(byte[] bytes, SpeedyHost remoteHost, int eventId) {
        if (this.started) {
            if (this.eventId == eventId) {
                if (!this.droppingPackets) {
                    NetworkQueue networkQueue = this.networkQueues.get(remoteHost);
                    networkQueue.putFragment(bytes);
                    networkQueue.executeFragments();
                }
            } else {
                this.eventResponseList.add(new EventResponse(bytes, remoteHost, eventId));
            }
        } else {
            this.preStartMessages.add(new EventResponse(bytes, remoteHost, eventId));
        }
    }

    public void start() {
        EventResponse preStartMessage;
        this.started = true;
        int eventId = this.startEvent();
        while ((preStartMessage = this.preStartMessages.poll()) != null) {
            this.send(preStartMessage.bytes, preStartMessage.remoteHost, eventId);
        }
        this.completeEvent(eventId);
    }

    public void startDroppingPackets() {
        this.droppingPackets = true;
    }

    public void stopDroppingPackets() {
        this.droppingPackets = false;
    }

    public int startEvent() {
        int currentEventId = this.eventId++;
        if (this.started && currentEventId == this.completedEventId) {
            return this.eventId;
        }
        return -1;
    }

    public void completeEvent(int eventId) {
        if (this.started && eventId == this.completedEventId + 1) {
            ++this.completedEventId;
            if (!this.eventResponseList.isEmpty()) {
                int newEventId = this.startEvent();
                ArrayList<EventResponse> tempCopy = new ArrayList<EventResponse>(this.eventResponseList);
                this.eventResponseList.clear();
                for (EventResponse eventResponse : tempCopy) {
                    this.send(eventResponse.bytes, eventResponse.remoteHost, newEventId);
                }
                this.completeEvent(newEventId);
            }
        }
    }

    public void onPulse() {
        this.pulseHandlers.forEach(Runnable::run);
    }

    public void fastForwardTimeInNanos(long timeInNanosToFastForwardBy) {
        this.nanoTime += timeInNanosToFastForwardBy;
    }

    public long getNanoTime() {
        return this.nanoTime;
    }

    public void addPulseHandler(Runnable pulseHandler) {
        this.pulseHandlers.add(pulseHandler);
    }
}

