/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.wiring;

import io.kiw.speedy.SpeedyConnection;
import io.kiw.speedy.SpeedyHost;
import io.kiw.speedy.helper.ImmutableIntMap;
import io.kiw.speedy.marshaller.PacketHandler;
import io.kiw.speedy.marshaller.PacketHandlerImpl;
import io.kiw.speedy.publisher.SchedulerThread;
import io.kiw.speedy.publisher.SpeedyMessagingPublisher;
import io.kiw.speedy.subscriber.HandleMessageEvent;
import io.kiw.speedy.subscriber.SpeedyMessagingSubscriber;
import io.kiw.speedy.wiring.MultiThreadSubscriberHandler;
import io.kiw.speedy.wiring.SameThreadHandler;
import io.kiw.speedy.wiring.SpeedyWiring;
import io.kiw.speedy.wiring.StubMultiThreadSubscriberHandler;
import io.kiw.speedy.wiring.StubRouter;
import io.kiw.speedy.wiring.thread.ThreadHandler;
import io.kiw.tetryon.Tetryon;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class StubWiring
implements SpeedyWiring {
    private final SameThreadHandler sameThreadHandler = new SameThreadHandler();
    private StubRouter stubRouter;
    private SpeedyHost localHost;
    private PacketHandlerImpl messageTranslator;
    private boolean autoFlushing = true;
    private List<Integer> eventWavesIds = new ArrayList<Integer>();

    public StubWiring(StubRouter stubRouter, SpeedyHost localHost) {
        this.localHost = localHost;
        this.stubRouter = stubRouter;
    }

    @Override
    public void sendPacket(ByteBuffer writeBuffer, SpeedyHost remoteHost) {
        byte[] bytes = new byte[writeBuffer.remaining()];
        writeBuffer.get(bytes, writeBuffer.position(), writeBuffer.limit());
        this.stubRouter.send(bytes, remoteHost, this.getCurrentEventId());
    }

    public Integer getCurrentEventId() {
        return this.eventWavesIds.get(this.eventWavesIds.size() - 1);
    }

    @Override
    public void closePublisher() {
    }

    @Override
    public void receive(ByteBuffer readBuffer) {
        readBuffer.put(this.stubRouter.receive(this.localHost));
    }

    @Override
    public void closeSubscriber() {
    }

    @Override
    public void registerFragmentHandler(Runnable fragmentHandler) {
        this.stubRouter.addFragmentHandler(this.localHost, fragmentHandler);
    }

    @Override
    public ThreadHandler getThreadHandler() {
        return this.sameThreadHandler;
    }

    @Override
    public void connectToRemoteHost(SpeedyConnection speedyConnection, Runnable publishTask) {
        publishTask.run();
    }

    @Override
    public void start(SpeedyMessagingPublisher speedyMessagingPublisher, SpeedyMessagingSubscriber speedyMessagingSubscriber, SchedulerThread schedulerThread, ImmutableIntMap<SpeedyConnection> remoteConnections) {
        speedyMessagingPublisher.enable();
        speedyMessagingSubscriber.addNackScheduledJob();
    }

    @Override
    public void connectIfSingleConnection(ImmutableIntMap<SpeedyConnection> remoteConnections) {
    }

    @Override
    public int startEvent() {
        int eventWaveId = this.stubRouter.startEvent();
        this.eventWavesIds.add(eventWaveId);
        return eventWaveId;
    }

    @Override
    public void addPulseHandler(Runnable pulseHandler) {
        this.stubRouter.addPulseHandler(pulseHandler);
    }

    @Override
    public MultiThreadSubscriberHandler buildMultiThreadSubscriberHandler(List<Tetryon.EventHandler<HandleMessageEvent>> group) {
        return new StubMultiThreadSubscriberHandler(group);
    }

    @Override
    public void completeEvent(int eventId) {
        if (this.autoFlushing) {
            this.messageTranslator.flushBucketsIfRequired();
        }
        this.eventWavesIds.remove(this.eventWavesIds.size() - 1);
        this.stubRouter.completeEvent(eventId);
    }

    @Override
    public long getNanoTime() {
        return this.stubRouter.getNanoTime();
    }

    @Override
    public PacketHandler wrapPacketHandler(PacketHandlerImpl delegate) {
        this.messageTranslator = delegate;
        return this.messageTranslator;
    }

    public void setAutoFlushing(boolean autoFlushing) {
        this.autoFlushing = autoFlushing;
    }
}

