/*
 * Decompiled with CFR 0.152.
 */
package io.kiw.speedy.wiring;

import io.kiw.speedy.SpeedyConnection;
import io.kiw.speedy.SpeedyHost;
import io.kiw.speedy.helper.ImmutableIntMap;
import io.kiw.speedy.marshaller.PacketHandler;
import io.kiw.speedy.marshaller.PacketHandlerImpl;
import io.kiw.speedy.publisher.SchedulerThread;
import io.kiw.speedy.publisher.SpeedyMessagingPublisher;
import io.kiw.speedy.subscriber.HandleMessageEvent;
import io.kiw.speedy.subscriber.SpeedyMessagingSubscriber;
import io.kiw.speedy.wiring.MultiThreadSubscriberHandler;
import io.kiw.speedy.wiring.SpeedyWiring;
import io.kiw.speedy.wiring.TetryonMultiThreadSubscriberHandler;
import io.kiw.speedy.wiring.thread.MultiThreadHandler;
import io.kiw.speedy.wiring.thread.ThreadHandler;
import io.kiw.tetryon.Tetryon;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.List;

public class UdpSpeedyWiring
implements SpeedyWiring {
    public static final int RCF_BUFFER_SIZE = 0x1000000;
    private final DatagramChannel subscriberDatagramChannel;
    private final DatagramChannel publisherDatagramChannel;
    private final MultiThreadHandler multiThreadHandler = new MultiThreadHandler();
    private Thread subcriberThread;

    public UdpSpeedyWiring(int subscriberPort) {
        this.subscriberDatagramChannel = UdpSpeedyWiring.createsubscriberDatagramChannel(subscriberPort);
        this.publisherDatagramChannel = UdpSpeedyWiring.createPublisherDatagramChannel();
    }

    @Override
    public void sendPacket(ByteBuffer writeBuffer, SpeedyHost speedyHost) {
        try {
            this.publisherDatagramChannel.send(writeBuffer, speedyHost.getSocketAddress());
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void closePublisher() {
        try {
            this.publisherDatagramChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void receive(ByteBuffer readBuffer) {
        try {
            this.subscriberDatagramChannel.receive(readBuffer);
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void closeSubscriber() {
        try {
            this.subscriberDatagramChannel.close();
            this.subcriberThread.interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void registerFragmentHandler(Runnable fragmentHandler) {
    }

    @Override
    public ThreadHandler getThreadHandler() {
        return this.multiThreadHandler;
    }

    @Override
    public void connectToRemoteHost(SpeedyConnection speedyConnection, Runnable publishTask) {
        this.getThreadHandler().run(sleepHandler -> {
            while (!speedyConnection.theyHaveAcknowledgedUs()) {
                publishTask.run();
                sleepHandler.sleep(10);
            }
            while (!speedyConnection.weHaveAcknowledgedThem()) {
                sleepHandler.sleep(10);
            }
        });
    }

    @Override
    public void start(SpeedyMessagingPublisher speedyMessagingPublisher, SpeedyMessagingSubscriber speedyMessagingSubscriber, SchedulerThread schedulerThread, ImmutableIntMap<SpeedyConnection> remoteConnections) {
        speedyMessagingSubscriber.addNackScheduledJob();
        speedyMessagingPublisher.start();
        this.subcriberThread = new Thread((Runnable)speedyMessagingSubscriber, "SpeedyMessagingSubscriber-Thread");
        this.subcriberThread.start();
        schedulerThread.start();
    }

    @Override
    public void connectIfSingleConnection(ImmutableIntMap<SpeedyConnection> remoteConnections) {
        if (remoteConnections.size() == 1) {
            try {
                this.publisherDatagramChannel.connect(remoteConnections.values().iterator().next().getHost().getSocketAddress());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void completeEvent(int eventId) {
    }

    @Override
    public long getNanoTime() {
        return System.nanoTime();
    }

    @Override
    public PacketHandler wrapPacketHandler(PacketHandlerImpl packetHandler) {
        return packetHandler;
    }

    @Override
    public int startEvent() {
        return 0;
    }

    @Override
    public void addPulseHandler(Runnable pulse) {
    }

    @Override
    public MultiThreadSubscriberHandler buildMultiThreadSubscriberHandler(List<Tetryon.EventHandler<HandleMessageEvent>> group) {
        return new TetryonMultiThreadSubscriberHandler(group);
    }

    private static DatagramChannel createsubscriberDatagramChannel(int port) {
        try {
            return ((DatagramChannel)((DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)0x1000000)).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).bind(new InetSocketAddress(port));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static DatagramChannel createPublisherDatagramChannel() {
        try {
            return DatagramChannel.open(StandardProtocolFamily.INET);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

