/*
 * Decompiled with CFR 0.152.
 */
package io.klogging;

import io.klogging.BaseLoggerKt;
import io.klogging.Level;
import io.klogging.events.LogEvent;
import io.klogging.internal.KloggingEngine;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\bf\u0018\u00002\u00020\u0001JP\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00012\u001a\b\u0002\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000fj\u0002`\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001a"}, d2={"Lio/klogging/BaseLogger;", "", "name", "", "getName", "()Ljava/lang/String;", "eventFrom", "Lio/klogging/events/LogEvent;", "context", "level", "Lio/klogging/Level;", "throwable", "", "eventObject", "contextItems", "", "Lio/klogging/events/EventItems;", "isDebugEnabled", "", "isErrorEnabled", "isFatalEnabled", "isInfoEnabled", "isLevelEnabled", "isTraceEnabled", "isWarnEnabled", "minLevel", "klogging"})
public interface BaseLogger {
    @NotNull
    public String getName();

    @NotNull
    public Level minLevel();

    public boolean isLevelEnabled(@NotNull Level var1);

    public boolean isTraceEnabled();

    public boolean isDebugEnabled();

    public boolean isInfoEnabled();

    public boolean isWarnEnabled();

    public boolean isErrorEnabled();

    public boolean isFatalEnabled();

    @NotNull
    public LogEvent eventFrom(@Nullable String var1, @NotNull Level var2, @Nullable Throwable var3, @Nullable Object var4, @NotNull Map<String, ? extends Object> var5);

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Level minLevel(@NotNull BaseLogger $this) {
            return KloggingEngine.INSTANCE.minimumLevelOf$klogging($this.getName());
        }

        public static boolean isLevelEnabled(@NotNull BaseLogger $this, @NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            return WhenMappings.$EnumSwitchMapping$0[level.ordinal()] == 1 ? false : $this.minLevel().compareTo((Enum)level) <= 0;
        }

        public static boolean isTraceEnabled(@NotNull BaseLogger $this) {
            return $this.isLevelEnabled(Level.TRACE);
        }

        public static boolean isDebugEnabled(@NotNull BaseLogger $this) {
            return $this.isLevelEnabled(Level.DEBUG);
        }

        public static boolean isInfoEnabled(@NotNull BaseLogger $this) {
            return $this.isLevelEnabled(Level.INFO);
        }

        public static boolean isWarnEnabled(@NotNull BaseLogger $this) {
            return $this.isLevelEnabled(Level.WARN);
        }

        public static boolean isErrorEnabled(@NotNull BaseLogger $this) {
            return $this.isLevelEnabled(Level.ERROR);
        }

        public static boolean isFatalEnabled(@NotNull BaseLogger $this) {
            return $this.isLevelEnabled(Level.FATAL);
        }

        @NotNull
        public static LogEvent eventFrom(@NotNull BaseLogger $this, @Nullable String context, @NotNull Level level, @Nullable Throwable throwable, @Nullable Object eventObject, @NotNull Map<String, ? extends Object> contextItems) {
            LogEvent logEvent;
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter(contextItems, (String)"contextItems");
            if (eventObject instanceof LogEvent) {
                Throwable throwable2 = throwable;
                logEvent = ((LogEvent)eventObject).copyWith$klogging(level, throwable2 != null ? ExceptionsKt.stackTraceToString((Throwable)throwable2) : null, contextItems);
            } else {
                Pair<String, String> pair = BaseLoggerKt.messageAndStackTrace(eventObject, throwable);
                String message = (String)pair.component1();
                String stackTrace = (String)pair.component2();
                logEvent = new LogEvent(null, null, null, $this.getName(), context, level, null, message, stackTrace, contextItems, 71, null);
            }
            return logEvent;
        }

        public static /* synthetic */ LogEvent eventFrom$default(BaseLogger baseLogger, String string, Level level, Throwable throwable, Object object, Map map, int n, Object object2) {
            if (object2 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: eventFrom");
            }
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            if ((n & 8) != 0) {
                object = null;
            }
            if ((n & 0x10) != 0) {
                map = MapsKt.emptyMap();
            }
            return baseLogger.eventFrom(string, level, throwable, object, map);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

