/*
 * Decompiled with CFR 0.152.
 */
package io.klogging.config;

import io.klogging.config.ConfigFile;
import io.klogging.config.EnvironmentKt;
import io.klogging.config.HoconConfiguration;
import io.klogging.config.JsonConfiguration;
import io.klogging.config.KloggingConfiguration;
import io.klogging.internal.InternalLoggingKt;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0000\u00a8\u0006\u000b"}, d2={"configureFromFile", "Lio/klogging/config/KloggingConfiguration;", "configFile", "Lio/klogging/config/ConfigFile;", "fileText", "", "filePath", "findConfigFile", "configPath", "readResourceText", "resourcePath", "klogging"})
@SourceDebugExtension(value={"SMAP\nFiles.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Files.jvm.kt\nio/klogging/config/Files_jvmKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class Files_jvmKt {
    @Nullable
    public static final String readResourceText(@NotNull String resourcePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
        if (inputStream != null) {
            Reader reader = new InputStreamReader(inputStream, Charsets.UTF_8);
            int n = 8192;
            BufferedReader it = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
            boolean bl = false;
            InternalLoggingKt.debug$default("Configuration", "Reading configuration from " + resourcePath + " on the classpath", null, 4, null);
            string = TextStreamsKt.readText((Reader)it);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String fileText(@Nullable String filePath) {
        String string;
        String string2 = filePath;
        if (string2 != null) {
            String path = string2;
            boolean bl = false;
            File file = new File(path);
            boolean bl2 = false;
            if (file.exists()) {
                InternalLoggingKt.debug$default("Configuration", "Reading configuration from " + filePath, null, 4, null);
                string = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
            } else {
                InternalLoggingKt.warn$default("Configuration", "Specified configuration file " + filePath + " not found", null, 4, null);
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final ConfigFile findConfigFile(@Nullable String configPath) {
        ConfigFile configFile;
        String string = configPath;
        if (string == null && (string = EnvironmentKt.getenv("KLOGGING_CONFIG_JSON_PATH")) == null) {
            string = EnvironmentKt.getenv("KLOGGING_CONFIG_PATH");
        }
        String filePath = string;
        String path = null;
        path = filePath;
        String contents = null;
        contents = Files_jvmKt.fileText(filePath);
        if (contents == null) {
            contents = Files_jvmKt.readResourceText("klogging.json");
            path = "klogging.json";
        }
        if (contents == null) {
            contents = Files_jvmKt.readResourceText("klogging.conf");
            path = "klogging.conf";
        }
        String string2 = path;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            String string3 = contents;
            if (string3 != null) {
                String it2 = string3;
                boolean bl2 = false;
                configFile = new ConfigFile(path, contents);
            } else {
                configFile = null;
            }
        } else {
            configFile = null;
        }
        return configFile;
    }

    public static /* synthetic */ ConfigFile findConfigFile$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return Files_jvmKt.findConfigFile(string);
    }

    @Nullable
    public static final KloggingConfiguration configureFromFile(@Nullable ConfigFile configFile) {
        KloggingConfiguration kloggingConfiguration;
        ConfigFile configFile2 = configFile;
        if (configFile2 != null) {
            ConfigFile it = configFile2;
            boolean bl = false;
            String string = configFile.getPath().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null)) {
                kloggingConfiguration = JsonConfiguration.INSTANCE.configure(configFile.getContents());
            } else {
                String string2 = configFile.getPath().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                kloggingConfiguration = StringsKt.endsWith$default((String)string2, (String)".conf", (boolean)false, (int)2, null) ? HoconConfiguration.INSTANCE.configure(configFile.getContents()) : null;
            }
        } else {
            kloggingConfiguration = null;
        }
        return kloggingConfiguration;
    }
}

