/*
 * Decompiled with CFR 0.152.
 */
package io.klogging.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import io.klogging.Level;
import io.klogging.config.BuiltInsKt;
import io.klogging.config.EnvironmentKt;
import io.klogging.config.FileConfiguration;
import io.klogging.config.FileLoggingConfig;
import io.klogging.config.FileSinkConfiguration;
import io.klogging.config.HoconConfiguration;
import io.klogging.config.KloggingConfiguration;
import io.klogging.config.SinkConfiguration;
import io.klogging.context.Context;
import io.klogging.internal.InternalLoggingKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.hocon.Hocon;
import kotlinx.serialization.hocon.HoconKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0017\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/klogging/config/HoconConfiguration;", "", "()V", "hocon", "Lkotlinx/serialization/hocon/Hocon;", "configure", "Lio/klogging/config/KloggingConfiguration;", "configHocon", "", "readConfig", "Lio/klogging/config/FileConfiguration;", "readConfig$klogging", "klogging"})
@SourceDebugExtension(value={"SMAP\nHoconConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoconConfiguration.kt\nio/klogging/config/HoconConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,78:1\n1#2:79\n1557#3:80\n1628#3,3:81\n1863#3,2:88\n37#4,2:84\n216#5,2:86\n*S KotlinDebug\n*F\n+ 1 HoconConfiguration.kt\nio/klogging/config/HoconConfiguration\n*L\n53#1:80\n53#1:81,3\n70#1:88,2\n53#1:84,2\n63#1:86,2\n*E\n"})
public final class HoconConfiguration {
    @NotNull
    public static final HoconConfiguration INSTANCE = new HoconConfiguration();
    @NotNull
    private static final Hocon hocon = HoconKt.Hocon$default(null, (Function1)hocon.1.INSTANCE, (int)1, null);

    private HoconConfiguration() {
    }

    @Nullable
    public final FileConfiguration readConfig$klogging(@NotNull String configHocon) {
        FileConfiguration fileConfiguration;
        Intrinsics.checkNotNullParameter((Object)configHocon, (String)"configHocon");
        try {
            Config config = ConfigFactory.parseString((String)configHocon).resolve();
            DeserializationStrategy deserializationStrategy = (DeserializationStrategy)FileConfiguration.Companion.serializer();
            Intrinsics.checkNotNullExpressionValue((Object)config, (String)"config");
            fileConfiguration = (FileConfiguration)hocon.decodeFromConfig(deserializationStrategy, config);
        }
        catch (ConfigException ex) {
            InternalLoggingKt.warn("HoconConfiguration", "Exception parsing HOCON", ex);
            fileConfiguration = null;
        }
        return fileConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KloggingConfiguration configure(@NotNull String configHocon) {
        KloggingConfiguration kloggingConfiguration;
        Intrinsics.checkNotNullParameter((Object)configHocon, (String)"configHocon");
        FileConfiguration fileConfiguration = this.readConfig$klogging(configHocon);
        if (fileConfiguration != null) {
            Iterator iterator;
            FileConfiguration fileConfiguration2 = fileConfiguration;
            boolean bl = false;
            String configName = fileConfiguration2.component1();
            Level minLogLevel = fileConfiguration2.component2();
            Level minDirectLogLevel = fileConfiguration2.component3();
            Map<String, FileSinkConfiguration> sinks = fileConfiguration2.component4();
            List<FileLoggingConfig> logging = fileConfiguration2.component5();
            Map<String, String> baseContext = fileConfiguration2.component6();
            if (!baseContext.isEmpty()) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = baseContext.entrySet();
                boolean $i$f$map = false;
                iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(TuplesKt.to(it.getKey(), (Object)EnvironmentKt.evalEnv$default((String)it.getValue(), null, 2, null)));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                Pair[] contextItems = thisCollection$iv.toArray(new Pair[0]);
                Context.INSTANCE.addBaseContext(Arrays.copyOf(contextItems, contextItems.length));
            }
            KloggingConfiguration config = new KloggingConfiguration();
            if (configName != null) {
                Function1<KloggingConfiguration, Unit> function1 = BuiltInsKt.getBuiltInConfigurations().get(configName);
                if (function1 != null) {
                    Function1<KloggingConfiguration, Unit> it = function1;
                    boolean bl3 = false;
                    KloggingConfiguration $i$f$mapTo = config;
                    it.invoke((Object)$i$f$mapTo);
                }
            } else {
                Map.Entry element$iv;
                config.setKloggingMinLogLevel$klogging(minLogLevel);
                config.setMinDirectLogLevel$klogging(minDirectLogLevel);
                Object $this$forEach$iv = sinks;
                boolean $i$f$forEach = false;
                iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    SinkConfiguration it;
                    Map.Entry $i$f$mapTo = element$iv = (Map.Entry)iterator.next();
                    boolean bl4 = false;
                    String key = (String)$i$f$mapTo.getKey();
                    FileSinkConfiguration value = (FileSinkConfiguration)$i$f$mapTo.getValue();
                    if (value.toSinkConfiguration$klogging() == null) continue;
                    boolean bl5 = false;
                    InternalLoggingKt.debug$default("HOCON Configuration", "Setting sink `" + key + "` with " + value, null, 4, null);
                    ((Map)config.getSinks$klogging()).put(key, it);
                }
                $this$forEach$iv = logging;
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    FileLoggingConfig it = (FileLoggingConfig)((Object)element$iv);
                    boolean bl6 = false;
                    InternalLoggingKt.debug$default("HOCON Configuration", "Adding logging config " + it, null, 4, null);
                    config.getConfigs$klogging().add(it.toLoggingConfig$klogging());
                }
            }
            kloggingConfiguration = config;
        } else {
            kloggingConfiguration = null;
        }
        return kloggingConfiguration;
    }
}

