/*
 * Decompiled with CFR 0.152.
 */
package io.klogging.config;

import io.klogging.Level;
import io.klogging.config.BuiltInsKt;
import io.klogging.config.EnvironmentKt;
import io.klogging.config.FileConfiguration;
import io.klogging.config.FileLoggingConfig;
import io.klogging.config.FileSinkConfiguration;
import io.klogging.config.JsonConfiguration;
import io.klogging.config.KloggingConfiguration;
import io.klogging.config.SinkConfiguration;
import io.klogging.context.Context;
import io.klogging.internal.InternalLoggingKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0017\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/klogging/config/JsonConfiguration;", "", "()V", "json", "Lkotlinx/serialization/json/Json;", "configure", "Lio/klogging/config/KloggingConfiguration;", "configJson", "", "readConfig", "Lio/klogging/config/FileConfiguration;", "readConfig$klogging", "klogging"})
@SourceDebugExtension(value={"SMAP\nJsonConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonConfiguration.kt\nio/klogging/config/JsonConfiguration\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,85:1\n96#2:86\n1#3:87\n1557#4:88\n1628#4,3:89\n1863#4,2:96\n37#5,2:92\n216#6,2:94\n*S KotlinDebug\n*F\n+ 1 JsonConfiguration.kt\nio/klogging/config/JsonConfiguration\n*L\n45#1:86\n60#1:88\n60#1:89,3\n77#1:96,2\n60#1:92,2\n70#1:94,2\n*E\n"})
public final class JsonConfiguration {
    @NotNull
    public static final JsonConfiguration INSTANCE = new JsonConfiguration();
    @NotNull
    private static final Json json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);

    private JsonConfiguration() {
    }

    @Nullable
    public final FileConfiguration readConfig$klogging(@NotNull String configJson) {
        FileConfiguration fileConfiguration;
        Intrinsics.checkNotNullParameter((Object)configJson, (String)"configJson");
        try {
            Json this_$iv = json;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            fileConfiguration = (FileConfiguration)this_$iv.decodeFromString((DeserializationStrategy)BuiltinSerializersKt.getNullable(FileConfiguration.Companion.serializer()), configJson);
        }
        catch (SerializationException ex) {
            InternalLoggingKt.warn("JsonConfiguration", "Exception parsing JSON", ex);
            fileConfiguration = null;
        }
        return fileConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KloggingConfiguration configure(@NotNull String configJson) {
        KloggingConfiguration kloggingConfiguration;
        Intrinsics.checkNotNullParameter((Object)configJson, (String)"configJson");
        FileConfiguration fileConfiguration = this.readConfig$klogging(configJson);
        if (fileConfiguration != null) {
            Iterator iterator;
            FileConfiguration fileConfiguration2 = fileConfiguration;
            boolean bl = false;
            String configName = fileConfiguration2.component1();
            Level minLogLevel = fileConfiguration2.component2();
            Level minDirectLogLevel = fileConfiguration2.component3();
            Map<String, FileSinkConfiguration> sinks = fileConfiguration2.component4();
            List<FileLoggingConfig> logging = fileConfiguration2.component5();
            Map<String, String> baseContext = fileConfiguration2.component6();
            if (!baseContext.isEmpty()) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = baseContext.entrySet();
                boolean $i$f$map = false;
                iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(TuplesKt.to(it.getKey(), (Object)EnvironmentKt.evalEnv$default((String)it.getValue(), null, 2, null)));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                Pair[] contextItems = thisCollection$iv.toArray(new Pair[0]);
                Context.INSTANCE.addBaseContext(Arrays.copyOf(contextItems, contextItems.length));
            }
            KloggingConfiguration config = new KloggingConfiguration();
            if (configName != null) {
                Function1<KloggingConfiguration, Unit> function1 = BuiltInsKt.getBuiltInConfigurations().get(configName);
                if (function1 != null) {
                    Function1<KloggingConfiguration, Unit> it = function1;
                    boolean bl3 = false;
                    KloggingConfiguration $i$f$mapTo = config;
                    it.invoke((Object)$i$f$mapTo);
                }
            } else {
                Map.Entry element$iv;
                config.setKloggingMinLogLevel$klogging(minLogLevel);
                config.setMinDirectLogLevel$klogging(minDirectLogLevel);
                Object $this$forEach$iv = sinks;
                boolean $i$f$forEach = false;
                iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    SinkConfiguration it;
                    Map.Entry $i$f$mapTo = element$iv = (Map.Entry)iterator.next();
                    boolean bl4 = false;
                    String key = (String)$i$f$mapTo.getKey();
                    FileSinkConfiguration value = (FileSinkConfiguration)$i$f$mapTo.getValue();
                    if (value.toSinkConfiguration$klogging() == null) continue;
                    boolean bl5 = false;
                    InternalLoggingKt.debug$default("JSON Configuration", "Setting sink `" + key + "` with " + value, null, 4, null);
                    ((Map)config.getSinks$klogging()).put(key, it);
                }
                $this$forEach$iv = logging;
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    FileLoggingConfig it = (FileLoggingConfig)((Object)element$iv);
                    boolean bl6 = false;
                    InternalLoggingKt.debug$default("JSON Configuration", "Adding logging config " + it, null, 4, null);
                    config.getConfigs$klogging().add(it.toLoggingConfig$klogging());
                }
            }
            kloggingConfiguration = config;
        } else {
            kloggingConfiguration = null;
        }
        return kloggingConfiguration;
    }
}

