/*
 * Decompiled with CFR 0.152.
 */
package io.klogging.config;

import io.klogging.AtomicMutableList;
import io.klogging.AtomicMutableMap;
import io.klogging.Level;
import io.klogging.config.ConfigDsl;
import io.klogging.config.KloggingConfigurationKt;
import io.klogging.config.LevelRange;
import io.klogging.config.LoggingConfig;
import io.klogging.config.SinkConfiguration;
import io.klogging.internal.InternalLoggingKt;
import io.klogging.rendering.RenderString;
import io.klogging.sending.EventSender;
import io.klogging.sending.SendString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u001fJ\u0010\u0010\b\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\tH\u0007J!\u0010!\u001a\u00020\u001d2\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001d0#\u00a2\u0006\u0002\b$H\u0007J\u0012\u0010\u000e\u001a\u00020\u001d2\b\u0010%\u001a\u0004\u0018\u00010\u000fH\u0007J\u0010\u0010\u0014\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\tH\u0007J\u000e\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u000fJ\u0018\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u0019H\u0007J \u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0007J\u0018\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010/\u001a\u000200H\u0007J\r\u00101\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b2R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\rR \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00190\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00063"}, d2={"Lio/klogging/config/KloggingConfiguration;", "", "()V", "configs", "Lio/klogging/AtomicMutableList;", "Lio/klogging/config/LoggingConfig;", "getConfigs$klogging", "()Lio/klogging/AtomicMutableList;", "kloggingMinLogLevel", "Lio/klogging/Level;", "getKloggingMinLogLevel$klogging", "()Lio/klogging/Level;", "setKloggingMinLogLevel$klogging", "(Lio/klogging/Level;)V", "loggingConfigPath", "", "getLoggingConfigPath$klogging", "()Ljava/lang/String;", "setLoggingConfigPath$klogging", "(Ljava/lang/String;)V", "minDirectLogLevel", "getMinDirectLogLevel$klogging", "setMinDirectLogLevel$klogging", "sinks", "Lio/klogging/AtomicMutableMap;", "Lio/klogging/config/SinkConfiguration;", "getSinks$klogging", "()Lio/klogging/AtomicMutableMap;", "append", "", "other", "append$klogging", "minLevel", "logging", "configBlock", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "configPath", "minimumLevelOf", "loggerName", "sink", "sinkName", "sinkConfig", "renderer", "Lio/klogging/rendering/RenderString;", "sender", "Lio/klogging/sending/SendString;", "eventSender", "Lio/klogging/sending/EventSender;", "validateSinks", "validateSinks$klogging", "klogging"})
@SourceDebugExtension(value={"SMAP\nKloggingConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KloggingConfiguration.kt\nio/klogging/config/KloggingConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n774#2:232\n865#2,2:233\n1368#2:235\n1454#2,5:236\n1368#2:242\n1454#2,5:243\n1368#2:248\n1454#2,5:249\n1863#2,2:254\n1#3:241\n*S KotlinDebug\n*F\n+ 1 KloggingConfiguration.kt\nio/klogging/config/KloggingConfiguration\n*L\n196#1:232\n196#1:233,2\n197#1:235\n197#1:236,5\n203#1:242\n203#1:243,5\n204#1:248\n204#1:249,5\n207#1:254,2\n*E\n"})
public final class KloggingConfiguration {
    @NotNull
    private final AtomicMutableMap<String, SinkConfiguration> sinks = new AtomicMutableMap(new Pair[0]);
    @NotNull
    private final AtomicMutableList<LoggingConfig> configs = new AtomicMutableList<LoggingConfig>(new LoggingConfig[0]);
    @Nullable
    private String loggingConfigPath;
    @NotNull
    private Level kloggingMinLogLevel = KloggingConfigurationKt.getDefaultKloggingMinLogLevel();
    @NotNull
    private Level minDirectLogLevel = KloggingConfigurationKt.getDefaultMinDirectLogLevel();

    @NotNull
    public final AtomicMutableMap<String, SinkConfiguration> getSinks$klogging() {
        return this.sinks;
    }

    @NotNull
    public final AtomicMutableList<LoggingConfig> getConfigs$klogging() {
        return this.configs;
    }

    @Nullable
    public final String getLoggingConfigPath$klogging() {
        return this.loggingConfigPath;
    }

    public final void setLoggingConfigPath$klogging(@Nullable String string) {
        this.loggingConfigPath = string;
    }

    @NotNull
    public final Level getKloggingMinLogLevel$klogging() {
        return this.kloggingMinLogLevel;
    }

    public final void setKloggingMinLogLevel$klogging(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"<set-?>");
        this.kloggingMinLogLevel = level;
    }

    @NotNull
    public final Level getMinDirectLogLevel$klogging() {
        return this.minDirectLogLevel;
    }

    public final void setMinDirectLogLevel$klogging(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"<set-?>");
        this.minDirectLogLevel = level;
    }

    @ConfigDsl
    public final void loggingConfigPath(@Nullable String configPath) {
        this.loggingConfigPath = configPath;
    }

    @ConfigDsl
    public final void kloggingMinLogLevel(@NotNull Level minLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)minLevel), (String)"minLevel");
        this.kloggingMinLogLevel = minLevel;
    }

    @ConfigDsl
    public final void minDirectLogLevel(@NotNull Level minLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)minLevel), (String)"minLevel");
        this.minDirectLogLevel = minLevel;
    }

    @ConfigDsl
    public final void sink(@NotNull String sinkName, @NotNull SinkConfiguration sinkConfig) {
        Intrinsics.checkNotNullParameter((Object)sinkName, (String)"sinkName");
        Intrinsics.checkNotNullParameter((Object)sinkConfig, (String)"sinkConfig");
        ((Map)this.sinks).put(sinkName, sinkConfig);
    }

    @ConfigDsl
    public final void sink(@NotNull String sinkName, @NotNull RenderString renderer, @NotNull SendString sender) {
        Intrinsics.checkNotNullParameter((Object)sinkName, (String)"sinkName");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        ((Map)this.sinks).put(sinkName, new SinkConfiguration(renderer, sender, null, 4, null));
    }

    @ConfigDsl
    public final void sink(@NotNull String sinkName, @NotNull EventSender eventSender) {
        Intrinsics.checkNotNullParameter((Object)sinkName, (String)"sinkName");
        Intrinsics.checkNotNullParameter((Object)eventSender, (String)"eventSender");
        ((Map)this.sinks).put(sinkName, new SinkConfiguration(null, null, eventSender, 3, null));
    }

    @ConfigDsl
    public final void logging(@NotNull Function1<? super LoggingConfig, Unit> configBlock) {
        LoggingConfig loggingConfig;
        Intrinsics.checkNotNullParameter(configBlock, (String)"configBlock");
        LoggingConfig loggingConfig2 = loggingConfig = new LoggingConfig();
        configBlock.invoke((Object)loggingConfig2);
        this.configs.add(loggingConfig);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Level minimumLevelOf(@NotNull String loggerName) {
        Level level;
        Object object;
        void $this$flatMapTo$iv$iv;
        LoggingConfig it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        Iterable $this$filter$iv = this.configs;
        boolean $i$f$filter = false;
        Object object2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LoggingConfig)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)it.getNameMatcher$klogging().invoke((Object)loggerName)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (LoggingConfig)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getRanges$klogging();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterator iterator = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!iterator.hasNext()) {
            object = null;
        } else {
            LevelRange it2 = (LevelRange)iterator.next();
            boolean bl = false;
            object2 = (Comparable)((Object)it2.getMinLevel());
            while (iterator.hasNext()) {
                LevelRange it3 = (LevelRange)iterator.next();
                $i$a$-minOfOrNull-KloggingConfiguration$minimumLevelOf$3 = false;
                Comparable comparable = (Comparable)((Object)it3.getMinLevel());
                if (object2.compareTo(comparable) <= 0) continue;
                object2 = comparable;
            }
            object = object2;
        }
        if ((level = (Level)((Object)object)) == null) {
            level = Level.NONE;
        }
        return level;
    }

    public final void validateSinks$klogging() {
        Iterable list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.configs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (LoggingConfig)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((LoggingConfig)it).getRanges$klogging();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (LevelRange)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((LevelRange)it).getSinkNames$klogging();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set loggingSinks = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set extraSinks = SetsKt.minus((Set)loggingSinks, (Iterable)this.sinks.keySet());
        Iterable $this$forEach$iv = extraSinks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            InternalLoggingKt.warn$default("Configuration", "Sink `" + it2 + "` was not defined and will be ignored", null, 4, null);
        }
    }

    public final void append$klogging(@NotNull KloggingConfiguration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.sinks.putAll((Map<String, SinkConfiguration>)other.sinks);
        this.configs.addAll((Collection<LoggingConfig>)other.configs);
        if (this.kloggingMinLogLevel.compareTo((Enum)other.kloggingMinLogLevel) > 0) {
            this.kloggingMinLogLevel = other.kloggingMinLogLevel;
        }
    }
}

