/*
 * Decompiled with CFR 0.152.
 */
package io.klogging.config;

import io.klogging.Level;
import io.klogging.config.ConfigDsl;
import io.klogging.config.LevelRange;
import io.klogging.config.LoggingConfigKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00170\u0004\u00a2\u0006\u0002\b\u001bH\u0007J\u001a\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u0006H\u0007J\u001a\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u0006H\u0007J)\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00170\u0004\u00a2\u0006\u0002\b\u001bH\u0007J1\u0010\"\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00170\u0004\u00a2\u0006\u0002\b\u001bH\u0007J\u001a\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u0006H\u0007J)\u0010&\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00170\u0004\u00a2\u0006\u0002\b\u001bH\u0007J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0005H\u0007R*\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lio/klogging/config/LoggingConfig;", "", "()V", "nameMatcher", "Lkotlin/Function1;", "", "", "Lio/klogging/config/Matcher;", "getNameMatcher$klogging", "()Lkotlin/jvm/functions/Function1;", "setNameMatcher$klogging", "(Lkotlin/jvm/functions/Function1;)V", "ranges", "", "Lio/klogging/config/LevelRange;", "getRanges$klogging", "()Ljava/util/List;", "stopOnMatch", "getStopOnMatch$klogging", "()Z", "setStopOnMatch$klogging", "(Z)V", "atLevel", "", "level", "Lio/klogging/Level;", "configBlock", "Lkotlin/ExtensionFunctionType;", "exactLogger", "exactName", "fromLoggerBase", "baseName", "fromMinLevel", "minLevel", "inLevelRange", "maxLevel", "matchLogger", "pattern", "toMaxLevel", "toSink", "sinkName", "klogging"})
public final class LoggingConfig {
    private boolean stopOnMatch;
    @NotNull
    private final List<LevelRange> ranges = new ArrayList();
    @NotNull
    private Function1<? super String, Boolean> nameMatcher = LoggingConfigKt.getMatchAll();

    public final boolean getStopOnMatch$klogging() {
        return this.stopOnMatch;
    }

    public final void setStopOnMatch$klogging(boolean bl) {
        this.stopOnMatch = bl;
    }

    @NotNull
    public final List<LevelRange> getRanges$klogging() {
        return this.ranges;
    }

    @NotNull
    public final Function1<String, Boolean> getNameMatcher$klogging() {
        return this.nameMatcher;
    }

    public final void setNameMatcher$klogging(@NotNull Function1<? super String, Boolean> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.nameMatcher = function1;
    }

    @ConfigDsl
    public final void fromLoggerBase(@NotNull String baseName, boolean stopOnMatch) {
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        this.nameMatcher = (Function1)new Function1<String, Boolean>(baseName){
            final /* synthetic */ String $baseName;
            {
                this.$baseName = $baseName;
                super(1);
            }

            public final Boolean invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.startsWith$default((String)it, (String)this.$baseName, (boolean)false, (int)2, null);
            }
        };
        this.stopOnMatch = stopOnMatch;
    }

    public static /* synthetic */ void fromLoggerBase$default(LoggingConfig loggingConfig, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        loggingConfig.fromLoggerBase(string, bl);
    }

    @ConfigDsl
    public final void exactLogger(@NotNull String exactName, boolean stopOnMatch) {
        Intrinsics.checkNotNullParameter((Object)exactName, (String)"exactName");
        this.nameMatcher = (Function1)new Function1<String, Boolean>(exactName){
            final /* synthetic */ String $exactName;
            {
                this.$exactName = $exactName;
                super(1);
            }

            public final Boolean invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it, (Object)this.$exactName);
            }
        };
        this.stopOnMatch = stopOnMatch;
    }

    public static /* synthetic */ void exactLogger$default(LoggingConfig loggingConfig, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        loggingConfig.exactLogger(string, bl);
    }

    @ConfigDsl
    public final void matchLogger(@NotNull String pattern, boolean stopOnMatch) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.nameMatcher = (Function1)new Function1<String, Boolean>(pattern){
            final /* synthetic */ String $pattern;
            {
                this.$pattern = $pattern;
                super(1);
            }

            public final Boolean invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new Regex(this.$pattern).matches((CharSequence)it);
            }
        };
        this.stopOnMatch = stopOnMatch;
    }

    public static /* synthetic */ void matchLogger$default(LoggingConfig loggingConfig, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        loggingConfig.matchLogger(string, bl);
    }

    @ConfigDsl
    public final void fromMinLevel(@NotNull Level minLevel, @NotNull Function1<? super LevelRange, Unit> configBlock) {
        LevelRange range;
        Intrinsics.checkNotNullParameter((Object)((Object)minLevel), (String)"minLevel");
        Intrinsics.checkNotNullParameter(configBlock, (String)"configBlock");
        LevelRange levelRange = range = LevelRange.Companion.invoke(minLevel, Level.FATAL);
        configBlock.invoke((Object)levelRange);
        if (!((Collection)range.getSinkNames$klogging()).isEmpty()) {
            this.ranges.add(range);
        }
    }

    @ConfigDsl
    public final void toMaxLevel(@NotNull Level maxLevel, @NotNull Function1<? super LevelRange, Unit> configBlock) {
        LevelRange range;
        Intrinsics.checkNotNullParameter((Object)((Object)maxLevel), (String)"maxLevel");
        Intrinsics.checkNotNullParameter(configBlock, (String)"configBlock");
        LevelRange levelRange = range = LevelRange.Companion.invoke(Level.TRACE, maxLevel);
        configBlock.invoke((Object)levelRange);
        if (!((Collection)range.getSinkNames$klogging()).isEmpty()) {
            this.ranges.add(range);
        }
    }

    @ConfigDsl
    public final void atLevel(@NotNull Level level, @NotNull Function1<? super LevelRange, Unit> configBlock) {
        LevelRange range;
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter(configBlock, (String)"configBlock");
        LevelRange levelRange = range = LevelRange.Companion.invoke(level, level);
        configBlock.invoke((Object)levelRange);
        if (!((Collection)range.getSinkNames$klogging()).isEmpty()) {
            this.ranges.add(range);
        }
    }

    @ConfigDsl
    public final void inLevelRange(@NotNull Level minLevel, @NotNull Level maxLevel, @NotNull Function1<? super LevelRange, Unit> configBlock) {
        LevelRange range;
        Intrinsics.checkNotNullParameter((Object)((Object)minLevel), (String)"minLevel");
        Intrinsics.checkNotNullParameter((Object)((Object)maxLevel), (String)"maxLevel");
        Intrinsics.checkNotNullParameter(configBlock, (String)"configBlock");
        LevelRange levelRange = range = LevelRange.Companion.invoke(minLevel, maxLevel);
        configBlock.invoke((Object)levelRange);
        if (!((Collection)range.getSinkNames$klogging()).isEmpty()) {
            this.ranges.add(range);
        }
    }

    @ConfigDsl
    public final void toSink(@NotNull String sinkName) {
        Intrinsics.checkNotNullParameter((Object)sinkName, (String)"sinkName");
        LevelRange range = LevelRange.Companion.invoke(Level.TRACE, Level.FATAL);
        range.toSink(sinkName);
        if (!((Collection)range.getSinkNames$klogging()).isEmpty()) {
            this.ranges.add(range);
        }
    }
}

