/*
 * Decompiled with CFR 0.152.
 */
package io.klogging.rendering;

import io.klogging.Level;
import io.klogging.events.LogEvent;
import io.klogging.rendering.EvalTemplateKt;
import io.klogging.rendering.RenderSimpleKt;
import io.klogging.rendering.RenderString;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\r\n\u0002\b\u0004\u001a\u000e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003\u001a\u000e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003\u001a\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003\u001a\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003\u001a\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\b\u0002\u0010\u001f\u001a\u00020\u0001\u001a\u000e\u0010 \u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u000e\u0010\t\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\n\u001a\u00020\u0003*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u0003*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\u0003*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0018\u0010\u0015\u001a\u00020\u0003*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\r\u00a8\u0006!"}, d2={"DEFAULT_MAX_WIDTH", "", "ESC", "", "MINIMUM_MAX_WIDTH", "RENDER_ANSI", "Lio/klogging/rendering/RenderString;", "getRENDER_ANSI", "()Lio/klogging/rendering/RenderString;", "delimiters", "colour5", "Lio/klogging/Level;", "getColour5", "(Lio/klogging/Level;)Ljava/lang/String;", "localTime", "Lkotlinx/datetime/Instant;", "getLocalTime", "(Lkotlinx/datetime/Instant;)Ljava/lang/String;", "right20", "getRight20", "(Ljava/lang/String;)Ljava/lang/String;", "rpad5", "getRpad5", "brightRed", "str", "green", "grey", "red", "shortenName", "", "name", "width", "yellow", "klogging"})
@SourceDebugExtension(value={"SMAP\nRenderAnsi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderAnsi.kt\nio/klogging/rendering/RenderAnsiKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,99:1\n1#2:100\n1188#3,3:101\n*S KotlinDebug\n*F\n+ 1 RenderAnsi.kt\nio/klogging/rendering/RenderAnsiKt\n*L\n78#1:101,3\n*E\n"})
public final class RenderAnsiKt {
    public static final int MINIMUM_MAX_WIDTH = 5;
    public static final int DEFAULT_MAX_WIDTH = 20;
    @NotNull
    private static final String ESC = "\u001b[";
    @NotNull
    private static final String delimiters = ". /:-+";
    @NotNull
    private static final RenderString RENDER_ANSI = new RenderString(){

        public String invoke(LogEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            String string = event.getContext();
            String message = RenderAnsiKt.getLocalTime(event.getTimestamp()) + ' ' + RenderAnsiKt.getColour5(event.getLevel()) + " [" + (string != null ? RenderAnsiKt.getRight20(string) : null) + "] : " + RenderAnsiKt.getRight20(event.getLogger()) + " : " + EvalTemplateKt.evalTemplate(event);
            String maybeItems = !event.getItems().isEmpty() ? " : " + event.getItems() : "";
            String maybeStackTrace = event.getStackTrace() != null ? '\n' + event.getStackTrace() : "";
            return message + maybeItems + maybeStackTrace;
        }
    };

    @NotNull
    public static final String getLocalTime(@NotNull Instant $this$localTime) {
        Intrinsics.checkNotNullParameter((Object)$this$localTime, (String)"<this>");
        String string = RenderSimpleKt.getLocalString($this$localTime).substring(11);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @NotNull
    public static final String grey(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return "\u001b[90m" + str + "\u001b[0m";
    }

    @NotNull
    public static final String green(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return "\u001b[32m" + str + "\u001b[0m";
    }

    @NotNull
    public static final String yellow(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return "\u001b[33m" + str + "\u001b[0m";
    }

    @NotNull
    public static final String red(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return "\u001b[31m" + str + "\u001b[0m";
    }

    @NotNull
    public static final String brightRed(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return "\u001b[91m" + str + "\u001b[0m";
    }

    private static final String getRpad5(Level $this$rpad5) {
        String it = ' ' + $this$rpad5.name();
        boolean bl = false;
        String string = it.substring(it.length() - 5);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @NotNull
    public static final String getColour5(@NotNull Level $this$colour5) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$colour5), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$colour5.ordinal()]) {
            case 1: {
                string = RenderAnsiKt.grey(RenderAnsiKt.getRpad5($this$colour5));
                break;
            }
            case 2: {
                string = RenderAnsiKt.getRpad5($this$colour5);
                break;
            }
            case 3: {
                string = RenderAnsiKt.green(RenderAnsiKt.getRpad5($this$colour5));
                break;
            }
            case 4: {
                string = RenderAnsiKt.yellow(RenderAnsiKt.getRpad5($this$colour5));
                break;
            }
            case 5: {
                string = RenderAnsiKt.red(RenderAnsiKt.getRpad5($this$colour5));
                break;
            }
            case 6: {
                string = RenderAnsiKt.brightRed(RenderAnsiKt.getRpad5($this$colour5));
                break;
            }
            default: {
                string = RenderAnsiKt.getRpad5($this$colour5);
            }
        }
        return string;
    }

    @NotNull
    public static final String getRight20(@NotNull String $this$right20) {
        Intrinsics.checkNotNullParameter((Object)$this$right20, (String)"<this>");
        String it = "                    " + RenderAnsiKt.shortenName($this$right20, 20);
        boolean bl = false;
        String string = it.substring(it.length() - 20);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CharSequence shortenName(@NotNull CharSequence name, int width) {
        int maxWidth;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int n = maxWidth = width < 5 ? 20 : width;
        if (name.length() <= maxWidth) {
            return name;
        }
        CharSequence $this$forEachIndexed$iv = name;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void char_;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n2 = index$iv++;
            char c = item$iv;
            int idx = n2;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)delimiters, (char)char_, (boolean)false, (int)2, null) || idx <= 0) continue;
            CharSequence charSequence = name;
            int n3 = idx + 1;
            int n4 = charSequence.length();
            return ((Object)name.subSequence(0, 1)).toString() + (char)char_ + RenderAnsiKt.shortenName(((Object)charSequence.subSequence(n3, n4)).toString(), maxWidth - 2);
        }
        return ((Object)name.subSequence(0, maxWidth)).toString();
    }

    public static /* synthetic */ CharSequence shortenName$default(CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 20;
        }
        return RenderAnsiKt.shortenName(charSequence, n);
    }

    @NotNull
    public static final RenderString getRENDER_ANSI() {
        return RENDER_ANSI;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.TRACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.FATAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

