/*
 * Decompiled with CFR 0.152.
 */
package io.klogging.sending;

import io.klogging.events.LogEvent;
import io.klogging.internal.InternalLoggingKt;
import io.klogging.sending.ElkEndpoint;
import io.klogging.sending.SendElkKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u00a8\u0006\t"}, d2={"elkConnection", "Ljava/net/HttpURLConnection;", "endpoint", "Lio/klogging/sending/ElkEndpoint;", "sendToElk", "", "batch", "", "Lio/klogging/events/LogEvent;", "klogging"})
@SourceDebugExtension(value={"SMAP\nElkSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElkSender.kt\nio/klogging/sending/ElkSenderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class ElkSenderKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void sendToElk(@NotNull ElkEndpoint endpoint, @NotNull List<LogEvent> batch) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(batch, (String)"batch");
        HttpURLConnection conn = ElkSenderKt.elkConnection(endpoint);
        try {
            InternalLoggingKt.trace$default("ELK", "Sending events to ELK in context " + Thread.currentThread().getName(), null, 4, null);
            Closeable closeable = conn.getOutputStream();
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                byte[] byArray = SendElkKt.elkBatch(batch).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                it.write(byArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e2) {
            InternalLoggingKt.warn$default("ELK", "exception sending message to ELK: " + e2, null, 4, null);
        }
    }

    private static final HttpURLConnection elkConnection(ElkEndpoint endpoint) {
        URLConnection uRLConnection = new URL(endpoint.getUrl()).openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection conn = (HttpURLConnection)uRLConnection;
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoOutput(true);
        return conn;
    }
}

