/*
 * Decompiled with CFR 0.152.
 */
package io.klogging.sending;

import io.klogging.internal.InternalLoggingKt;
import io.klogging.sending.Certificates;
import io.klogging.sending.InputStreamKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"sendToSeq", "", "url", "", "apiKey", "checkCertificate", "", "eventString", "seqConnection", "Ljava/net/HttpURLConnection;", "serverUrl", "klogging"})
@SourceDebugExtension(value={"SMAP\nSeq.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Seq.kt\nio/klogging/sending/SeqKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class SeqKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void sendToSeq(@NotNull String url, @Nullable String apiKey, boolean checkCertificate, @NotNull String eventString) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)eventString, (String)"eventString");
        HttpURLConnection conn = SeqKt.seqConnection(url, apiKey, checkCertificate);
        try {
            String string;
            Object object;
            InternalLoggingKt.trace$default("Seq", "Sending events to Seq in context " + Thread.currentThread().getName(), null, 4, null);
            Closeable closeable = conn.getOutputStream();
            Object object2 = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                byte[] byArray = eventString.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                it.write(byArray);
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            object2 = conn.getInputStream();
            object = null;
            try {
                InputStream it = (InputStream)object2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                string = new String(InputStreamKt.readAllTheBytes(it), Charsets.UTF_8);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
            String response = string;
            if (conn.getResponseCode() >= 400) {
                InternalLoggingKt.warn$default("Seq", "Error response " + conn.getResponseCode() + " sending CLEF message: " + response, null, 4, null);
            }
        }
        catch (IOException e2) {
            InternalLoggingKt.warn$default("Seq", "Exception sending CLEF message: " + e2, null, 4, null);
        }
    }

    private static final HttpURLConnection seqConnection(String serverUrl, String apiKey, boolean checkCertificate) {
        HttpURLConnection httpURLConnection;
        URL url = new URL(serverUrl + "/api/events/raw");
        if (StringsKt.startsWith$default((String)serverUrl, (String)"https://", (boolean)false, (int)2, null)) {
            HttpsURLConnection httpsURLConnection;
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
            HttpsURLConnection it = httpsURLConnection = (HttpsURLConnection)uRLConnection;
            boolean bl = false;
            if (!checkCertificate) {
                Certificates.INSTANCE.relaxHostChecking(it);
            }
            httpURLConnection = httpsURLConnection;
        } else {
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            httpURLConnection = (HttpURLConnection)uRLConnection;
        }
        HttpURLConnection conn = httpURLConnection;
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/vnd.serilog.clef");
        if (apiKey != null) {
            conn.setRequestProperty("X-Seq-ApiKey", apiKey);
        }
        conn.setDoOutput(true);
        return conn;
    }
}

