/*
 * Decompiled with CFR 0.152.
 */
package io.klogging.sending;

import io.klogging.events.LogEvent;
import io.klogging.internal.InternalLoggingKt;
import io.klogging.rendering.RenderString;
import io.klogging.sending.Certificates;
import io.klogging.sending.InputStreamKt;
import io.klogging.sending.SendSplunkKt;
import io.klogging.sending.SplunkEndpoint;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0000\u001a(\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0003H\u0000\u00a8\u0006\u0011"}, d2={"hecConnection", "Ljava/net/HttpURLConnection;", "hecUrl", "", "hecToken", "checkCertificate", "", "sendToSplunk", "", "endpoint", "Lio/klogging/sending/SplunkEndpoint;", "renderer", "Lio/klogging/rendering/RenderString;", "batch", "", "Lio/klogging/events/LogEvent;", "eventString", "klogging"})
@SourceDebugExtension(value={"SMAP\nSplunkHec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplunkHec.kt\nio/klogging/sending/SplunkHecKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class SplunkHecKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void sendToSplunk(@NotNull SplunkEndpoint endpoint, @NotNull RenderString renderer, @NotNull List<LogEvent> batch) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter(batch, (String)"batch");
        HttpURLConnection conn = SplunkHecKt.hecConnection(endpoint.getHecUrl(), endpoint.getHecToken(), Intrinsics.areEqual((Object)endpoint.getCheckCertificate(), (Object)"true"));
        try {
            String string;
            Object object;
            InternalLoggingKt.trace$default("Splunk", "Sending events to Splunk in context " + Thread.currentThread().getName(), null, 4, null);
            Closeable closeable = conn.getOutputStream();
            Object object2 = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                byte[] byArray = SendSplunkKt.splunkBatch(renderer, batch).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                it.write(byArray);
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            object2 = conn.getInputStream();
            object = null;
            try {
                InputStream it = (InputStream)object2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                string = new String(InputStreamKt.readAllTheBytes(it), Charsets.UTF_8);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
            String response = string;
            if (conn.getResponseCode() >= 400) {
                InternalLoggingKt.warn$default("Splunk", "Error response " + conn.getResponseCode() + " sending event to Splunk: " + response, null, 4, null);
            }
        }
        catch (IOException e2) {
            InternalLoggingKt.warn$default("Splunk", "Exception sending message to Splunk: " + e2, null, 4, null);
        }
    }

    private static final HttpURLConnection hecConnection(String hecUrl, String hecToken, boolean checkCertificate) {
        URLConnection uRLConnection = new URL(hecUrl + "/services/collector/event").openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        HttpsURLConnection conn = (HttpsURLConnection)uRLConnection;
        if (!checkCertificate) {
            Certificates.INSTANCE.relaxHostChecking(conn);
        }
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Authorization", "Splunk " + hecToken);
        conn.setDoOutput(true);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void sendToSplunk(@NotNull String hecUrl, @NotNull String hecToken, boolean checkCertificate, @NotNull String eventString) {
        Intrinsics.checkNotNullParameter((Object)hecUrl, (String)"hecUrl");
        Intrinsics.checkNotNullParameter((Object)hecToken, (String)"hecToken");
        Intrinsics.checkNotNullParameter((Object)eventString, (String)"eventString");
        HttpURLConnection conn = SplunkHecKt.hecConnection(hecUrl, hecToken, checkCertificate);
        try {
            String string;
            Object object;
            InternalLoggingKt.trace$default("Splunk", "Sending events to Splunk in context " + Thread.currentThread().getName(), null, 4, null);
            Closeable closeable = conn.getOutputStream();
            Object object2 = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                byte[] byArray = eventString.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                it.write(byArray);
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            object2 = conn.getInputStream();
            object = null;
            try {
                InputStream it = (InputStream)object2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                string = new String(InputStreamKt.readAllTheBytes(it), Charsets.UTF_8);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
            String response = string;
            if (conn.getResponseCode() >= 400) {
                InternalLoggingKt.warn$default("Splunk", "Error response " + conn.getResponseCode() + " sending event to Splunk: " + response, null, 4, null);
            }
        }
        catch (IOException e2) {
            InternalLoggingKt.warn$default("Splunk", "Exception sending message to Splunk: " + e2, null, 4, null);
        }
    }
}

