/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.knotx.reactivex.proxy;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.eventbus.DeliveryOptions;
import io.knotx.dataobjects.AdapterRequest;
import io.knotx.dataobjects.AdapterResponse;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;


@io.vertx.lang.rx.RxGen(io.knotx.proxy.AdapterProxy.class)
public class AdapterProxy {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AdapterProxy that = (AdapterProxy) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<AdapterProxy> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new AdapterProxy((io.knotx.proxy.AdapterProxy) obj),
    AdapterProxy::getDelegate
  );

  private final io.knotx.proxy.AdapterProxy delegate;
  
  public AdapterProxy(io.knotx.proxy.AdapterProxy delegate) {
    this.delegate = delegate;
  }

  public AdapterProxy(Object delegate) {
    this.delegate = (io.knotx.proxy.AdapterProxy)delegate;
  }

  public io.knotx.proxy.AdapterProxy getDelegate() {
    return delegate;
  }

  public static io.knotx.reactivex.proxy.AdapterProxy createProxy(io.vertx.reactivex.core.Vertx vertx, String address) { 
    io.knotx.reactivex.proxy.AdapterProxy ret = io.knotx.reactivex.proxy.AdapterProxy.newInstance((io.knotx.proxy.AdapterProxy)io.knotx.proxy.AdapterProxy.createProxy(vertx.getDelegate(), address));
    return ret;
  }

  public static io.knotx.reactivex.proxy.AdapterProxy createProxyWithOptions(io.vertx.reactivex.core.Vertx vertx, String address, DeliveryOptions deliveryOptions) { 
    io.knotx.reactivex.proxy.AdapterProxy ret = io.knotx.reactivex.proxy.AdapterProxy.newInstance((io.knotx.proxy.AdapterProxy)io.knotx.proxy.AdapterProxy.createProxyWithOptions(vertx.getDelegate(), address, deliveryOptions));
    return ret;
  }

  public void process(AdapterRequest request, Handler<AsyncResult<AdapterResponse>> result) { 
    delegate.process(request, result);
  }

  public Single<AdapterResponse> rxProcess(AdapterRequest request) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      process(request, handler);
    });
  }

  public static AdapterProxy newInstance(io.knotx.proxy.AdapterProxy arg) {
    return arg != null ? new AdapterProxy(arg) : null;
  }

}
