/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.knotx.reactivex.proxy;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.eventbus.DeliveryOptions;
import io.knotx.dataobjects.KnotContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;


@io.vertx.lang.rx.RxGen(io.knotx.proxy.KnotProxy.class)
public class KnotProxy {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KnotProxy that = (KnotProxy) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<KnotProxy> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new KnotProxy((io.knotx.proxy.KnotProxy) obj),
    KnotProxy::getDelegate
  );

  private final io.knotx.proxy.KnotProxy delegate;
  
  public KnotProxy(io.knotx.proxy.KnotProxy delegate) {
    this.delegate = delegate;
  }

  public KnotProxy(Object delegate) {
    this.delegate = (io.knotx.proxy.KnotProxy)delegate;
  }

  public io.knotx.proxy.KnotProxy getDelegate() {
    return delegate;
  }

  public static io.knotx.reactivex.proxy.KnotProxy createProxy(io.vertx.reactivex.core.Vertx vertx, String address) { 
    io.knotx.reactivex.proxy.KnotProxy ret = io.knotx.reactivex.proxy.KnotProxy.newInstance((io.knotx.proxy.KnotProxy)io.knotx.proxy.KnotProxy.createProxy(vertx.getDelegate(), address));
    return ret;
  }

  public static io.knotx.reactivex.proxy.KnotProxy createProxyWithOptions(io.vertx.reactivex.core.Vertx vertx, String address, DeliveryOptions deliveryOptions) { 
    io.knotx.reactivex.proxy.KnotProxy ret = io.knotx.reactivex.proxy.KnotProxy.newInstance((io.knotx.proxy.KnotProxy)io.knotx.proxy.KnotProxy.createProxyWithOptions(vertx.getDelegate(), address, deliveryOptions));
    return ret;
  }

  public void process(KnotContext knotContext, Handler<AsyncResult<KnotContext>> result) { 
    delegate.process(knotContext, result);
  }

  public Single<KnotContext> rxProcess(KnotContext knotContext) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      process(knotContext, handler);
    });
  }

  public static KnotProxy newInstance(io.knotx.proxy.KnotProxy arg) {
    return arg != null ? new KnotProxy(arg) : null;
  }

}
