/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.knotx.reactivex.proxy;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.eventbus.DeliveryOptions;
import io.knotx.dataobjects.ClientRequest;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.knotx.dataobjects.ClientResponse;


@io.vertx.lang.rx.RxGen(io.knotx.proxy.RepositoryConnectorProxy.class)
public class RepositoryConnectorProxy {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RepositoryConnectorProxy that = (RepositoryConnectorProxy) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<RepositoryConnectorProxy> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new RepositoryConnectorProxy((io.knotx.proxy.RepositoryConnectorProxy) obj),
    RepositoryConnectorProxy::getDelegate
  );

  private final io.knotx.proxy.RepositoryConnectorProxy delegate;
  
  public RepositoryConnectorProxy(io.knotx.proxy.RepositoryConnectorProxy delegate) {
    this.delegate = delegate;
  }

  public RepositoryConnectorProxy(Object delegate) {
    this.delegate = (io.knotx.proxy.RepositoryConnectorProxy)delegate;
  }

  public io.knotx.proxy.RepositoryConnectorProxy getDelegate() {
    return delegate;
  }

  public static io.knotx.reactivex.proxy.RepositoryConnectorProxy createProxy(io.vertx.reactivex.core.Vertx vertx, String address) { 
    io.knotx.reactivex.proxy.RepositoryConnectorProxy ret = io.knotx.reactivex.proxy.RepositoryConnectorProxy.newInstance((io.knotx.proxy.RepositoryConnectorProxy)io.knotx.proxy.RepositoryConnectorProxy.createProxy(vertx.getDelegate(), address));
    return ret;
  }

  public static io.knotx.reactivex.proxy.RepositoryConnectorProxy createProxyWithOptions(io.vertx.reactivex.core.Vertx vertx, String address, DeliveryOptions deliveryOptions) { 
    io.knotx.reactivex.proxy.RepositoryConnectorProxy ret = io.knotx.reactivex.proxy.RepositoryConnectorProxy.newInstance((io.knotx.proxy.RepositoryConnectorProxy)io.knotx.proxy.RepositoryConnectorProxy.createProxyWithOptions(vertx.getDelegate(), address, deliveryOptions));
    return ret;
  }

  public void process(ClientRequest request, Handler<AsyncResult<ClientResponse>> result) { 
    delegate.process(request, result);
  }

  public Single<ClientResponse> rxProcess(ClientRequest request) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      process(request, handler);
    });
  }

  public static RepositoryConnectorProxy newInstance(io.knotx.proxy.RepositoryConnectorProxy arg) {
    return arg != null ? new RepositoryConnectorProxy(arg) : null;
  }

}
