package io.knotx.repository.http;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

/**
 * Converter for {@link io.knotx.repository.http.HttpRepositoryOptions}.
 * NOTE: This class has been automatically generated from the {@link io.knotx.repository.http.HttpRepositoryOptions} original class using Vert.x codegen.
 */
 class HttpRepositoryOptionsConverter {

   static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, HttpRepositoryOptions obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "address":
          if (member.getValue() instanceof String) {
            obj.setAddress((String)member.getValue());
          }
          break;
        case "allowedRequestHeaders":
          if (member.getValue() instanceof JsonArray) {
            java.util.LinkedHashSet<java.lang.String> list =  new java.util.LinkedHashSet<>();
            ((Iterable<Object>)member.getValue()).forEach( item -> {
              if (item instanceof String)
                list.add((String)item);
            });
            obj.setAllowedRequestHeaders(list);
          }
          break;
        case "clientDestination":
          if (member.getValue() instanceof JsonObject) {
            obj.setClientDestination(new io.knotx.repository.http.ClientDestination((JsonObject)member.getValue()));
          }
          break;
        case "clientOptions":
          if (member.getValue() instanceof JsonObject) {
            obj.setClientOptions(new io.vertx.core.http.HttpClientOptions((JsonObject)member.getValue()));
          }
          break;
        case "customHttpHeader":
          if (member.getValue() instanceof JsonObject) {
            obj.setCustomHttpHeader(new io.knotx.configuration.CustomHttpHeader((JsonObject)member.getValue()));
          }
          break;
      }
    }
  }

   static void toJson(HttpRepositoryOptions obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

   static void toJson(HttpRepositoryOptions obj, java.util.Map<String, Object> json) {
    if (obj.getAddress() != null) {
      json.put("address", obj.getAddress());
    }
    if (obj.getAllowedRequestHeaders() != null) {
      JsonArray array = new JsonArray();
      obj.getAllowedRequestHeaders().forEach(item -> array.add(item));
      json.put("allowedRequestHeaders", array);
    }
    if (obj.getClientDestination() != null) {
      json.put("clientDestination", obj.getClientDestination().toJson());
    }
    if (obj.getClientOptions() != null) {
      json.put("clientOptions", obj.getClientOptions().toJson());
    }
    if (obj.getCustomHttpHeader() != null) {
      json.put("customHttpHeader", obj.getCustomHttpHeader().toJson());
    }
  }
}
