package io.knotx.server.configuration;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

/**
 * Converter for {@link io.knotx.server.configuration.KnotxFlowSettings}.
 * NOTE: This class has been automatically generated from the {@link io.knotx.server.configuration.KnotxFlowSettings} original class using Vert.x codegen.
 */
 class KnotxFlowSettingsConverter {

   static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, KnotxFlowSettings obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "assembler":
          if (member.getValue() instanceof String) {
            obj.setAssembler((String)member.getValue());
          }
          break;
        case "repositories":
          if (member.getValue() instanceof JsonArray) {
            java.util.ArrayList<io.knotx.server.configuration.RepositoryEntry> list =  new java.util.ArrayList<>();
            ((Iterable<Object>)member.getValue()).forEach( item -> {
              if (item instanceof JsonObject)
                list.add(new io.knotx.server.configuration.RepositoryEntry((JsonObject)item));
            });
            obj.setRepositories(list);
          }
          break;
        case "responseProvider":
          if (member.getValue() instanceof String) {
            obj.setResponseProvider((String)member.getValue());
          }
          break;
        case "routing":
          if (member.getValue() instanceof JsonObject) {
            java.util.Map<String, io.knotx.server.configuration.MethodRoutingEntries> map = new java.util.LinkedHashMap<>();
            ((Iterable<java.util.Map.Entry<String, Object>>)member.getValue()).forEach(entry -> {
              if (entry.getValue() instanceof JsonObject)
                map.put(entry.getKey(), new io.knotx.server.configuration.MethodRoutingEntries((JsonObject)entry.getValue()));
            });
            obj.setRouting(map);
          }
          break;
        case "splitter":
          if (member.getValue() instanceof String) {
            obj.setSplitter((String)member.getValue());
          }
          break;
      }
    }
  }

   static void toJson(KnotxFlowSettings obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

   static void toJson(KnotxFlowSettings obj, java.util.Map<String, Object> json) {
    if (obj.getAssembler() != null) {
      json.put("assembler", obj.getAssembler());
    }
    if (obj.getRepositories() != null) {
      JsonArray array = new JsonArray();
      obj.getRepositories().forEach(item -> array.add(item.toJson()));
      json.put("repositories", array);
    }
    if (obj.getResponseProvider() != null) {
      json.put("responseProvider", obj.getResponseProvider());
    }
    if (obj.getRouting() != null) {
      JsonObject map = new JsonObject();
      obj.getRouting().forEach((key, value) -> map.put(key, value.toJson()));
      json.put("routing", map);
    }
    if (obj.getSplitter() != null) {
      json.put("splitter", obj.getSplitter());
    }
  }
}
