/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.assembler;

import com.google.common.collect.Maps;
import io.knotx.assembler.FragmentAssemblerOptions;
import io.knotx.dataobjects.Fragment;
import io.knotx.dataobjects.KnotContext;
import io.knotx.fallback.FallbackStrategy;
import io.knotx.options.SnippetOptions;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;

public class FragmentAssemblerFallbackHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentAssemblerFallbackHandler.class);
    private final Map<String, FallbackStrategy> fallbackStrategies = Maps.newHashMap();
    private final FragmentAssemblerOptions options;

    public FragmentAssemblerFallbackHandler(FragmentAssemblerOptions options) {
        this.options = options;
        ServiceLoader<FallbackStrategy> fallbackStrategyServiceLoader = ServiceLoader.load(FallbackStrategy.class);
        for (FallbackStrategy strategy : fallbackStrategyServiceLoader) {
            this.fallbackStrategies.put(strategy.getId(), strategy);
        }
    }

    public String applyFallback(Fragment failed, KnotContext knotContext, Map<String, Fragment> fallbackFragmentCache) {
        Fragment fallback = this.getFallback(failed, knotContext, fallbackFragmentCache);
        FallbackStrategy strategy = this.getFallbackStrategy(fallback);
        return strategy.applyFallback(failed, fallback, knotContext);
    }

    private FallbackStrategy getFallbackStrategy(Fragment fallbackFragment) {
        String strategyId = Optional.ofNullable(fallbackFragment.getAttribute("fallback-strategy")).orElse("DEFAULT");
        return Optional.ofNullable(this.fallbackStrategies.get(strategyId)).orElseThrow(() -> {
            LOGGER.error((Object)"Fragment {} specifies fallback strategy but no fallback strategy with given id was found", new Object[]{fallbackFragment});
            return new IllegalArgumentException(String.format("no strategy with id %s found", strategyId));
        });
    }

    private Fragment getFallback(Fragment failed, KnotContext knotContext, Map<String, Fragment> fallbackFragmentCache) {
        String fallbackId = failed.fallback().get();
        Fragment result = fallbackFragmentCache.get(fallbackId);
        if (result == null) {
            result = knotContext.getFragments().stream().filter(f -> f.isFallback()).filter(f -> StringUtils.equals((CharSequence)fallbackId, (CharSequence)f.getAttribute("fallback-id"))).findFirst().orElse(null);
            if (result == null) {
                result = this.getGlobalFallback(failed).orElseThrow(() -> {
                    LOGGER.error((Object)"Fragment {} specifies fallback but no fallback snippet with id '{}' was found", new Object[]{failed, fallbackId});
                    return new IllegalArgumentException(String.format("No fallback snippet with id '%s' was found", fallbackId));
                });
            }
            fallbackFragmentCache.put(fallbackId, result);
        }
        return result;
    }

    private Optional<Fragment> getGlobalFallback(Fragment failed) {
        return this.options.getSnippetOptions().getFallbacks().stream().filter(f -> StringUtils.equals((CharSequence)failed.fallback().get(), (CharSequence)f.getId())).findFirst().map(fm -> Fragment.fallback(this.wrap(fm.getMarkup(), this.options.getSnippetOptions()), fm.getId()));
    }

    private String wrap(String fallbackMarkup, SnippetOptions snippetOptions) {
        return String.format("<%s>%s</%s>", snippetOptions.getFallbackTagName(), fallbackMarkup, snippetOptions.getFallbackTagName());
    }
}

