/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.assembler;

import com.google.common.collect.Maps;
import io.knotx.assembler.FragmentAssemblerFallbackHandler;
import io.knotx.assembler.FragmentAssemblerOptions;
import io.knotx.dataobjects.ClientResponse;
import io.knotx.dataobjects.Fragment;
import io.knotx.dataobjects.KnotContext;
import io.knotx.fragments.SnippetPatterns;
import io.knotx.knot.AbstractKnotProxy;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Single;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.core.MultiMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FragmentAssemblerKnotProxyImpl
extends AbstractKnotProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentAssemblerKnotProxyImpl.class);
    private final SnippetPatterns patterns;
    private FragmentAssemblerOptions options;
    private FragmentAssemblerFallbackHandler fallbackHandler;

    public FragmentAssemblerKnotProxyImpl(FragmentAssemblerOptions options) {
        this.options = options;
        this.patterns = new SnippetPatterns(options.getSnippetOptions());
        this.fallbackHandler = new FragmentAssemblerFallbackHandler(options);
    }

    @Override
    protected Single<KnotContext> processRequest(KnotContext knotContext) {
        if (this.hasFragments(knotContext)) {
            try {
                HashMap fallbackFragmentCache = Maps.newHashMap();
                String joinedFragments = knotContext.getFragments().stream().filter(f -> !f.isFallback()).map(f -> this.processFragment((Fragment)f, knotContext, fallbackFragmentCache)).collect(Collectors.joining());
                return Single.just((Object)this.createSuccessResponse(knotContext, joinedFragments));
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Exception happened during Fragment assembly.", (Throwable)ex);
                return Single.just((Object)this.processError(knotContext, ex));
            }
        }
        LOGGER.error((Object)"Fragments are empty or not exists in KnotContext.");
        return Single.just((Object)this.processError(knotContext, null));
    }

    private String processFragment(Fragment fragment, KnotContext knotContext, Map<String, Fragment> fallbackFragmentCache) {
        return fragment.failed() && fragment.fallback().isPresent() ? this.fallbackHandler.applyFallback(fragment, knotContext, fallbackFragmentCache) : this.options.getUnprocessedStrategy().get(fragment, this.patterns);
    }

    private boolean hasFragments(KnotContext knotContext) {
        return knotContext.getFragments() != null && !knotContext.getFragments().isEmpty();
    }

    @Override
    protected boolean shouldProcess(Set<String> knots) {
        return true;
    }

    @Override
    protected KnotContext processError(KnotContext knotContext, Throwable error) {
        ClientResponse errorResponse = new ClientResponse().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        return new KnotContext().setClientRequest(knotContext.getClientRequest()).setClientResponse(errorResponse);
    }

    private KnotContext createSuccessResponse(KnotContext inputContext, String renderedContent) {
        ClientResponse clientResponse = inputContext.getClientResponse();
        if (StringUtils.isBlank((CharSequence)renderedContent)) {
            clientResponse.setStatusCode(HttpResponseStatus.NO_CONTENT.code());
        } else {
            MultiMap headers = clientResponse.getHeaders();
            headers.add(HttpHeaders.CONTENT_LENGTH.toString().toLowerCase(), Integer.toString(renderedContent.length()));
            clientResponse.setBody(Buffer.buffer((String)renderedContent)).setHeaders(headers);
            clientResponse.setStatusCode(HttpResponseStatus.OK.code());
        }
        return new KnotContext().setClientRequest(inputContext.getClientRequest()).setClientResponse(clientResponse);
    }
}

