/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.assembler;

import io.knotx.assembler.FragmentAssemblerOptionsConverter;
import io.knotx.assembler.UnprocessedFragmentStrategy;
import io.knotx.options.SnippetOptions;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.Map;

@DataObject(generateConverter=true, publicConverter=false)
public class FragmentAssemblerOptions {
    private static final String DEFAULT_ADDRESS = "knotx.core.assembler";
    private static final UnprocessedFragmentStrategy DEFAULT_UNPROCESSED_STRATEGY = UnprocessedFragmentStrategy.UNWRAP;
    private String address;
    private UnprocessedFragmentStrategy unprocessedStrategy;
    private SnippetOptions snippetOptions;

    public FragmentAssemblerOptions() {
        this.init();
    }

    public FragmentAssemblerOptions(FragmentAssemblerOptions other) {
        this.address = other.address;
        this.snippetOptions = other.snippetOptions;
        this.unprocessedStrategy = other.unprocessedStrategy;
    }

    public FragmentAssemblerOptions(JsonObject json) {
        this.init();
        FragmentAssemblerOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        FragmentAssemblerOptionsConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.address = DEFAULT_ADDRESS;
        this.unprocessedStrategy = DEFAULT_UNPROCESSED_STRATEGY;
        this.snippetOptions = new SnippetOptions();
    }

    public String getAddress() {
        return this.address;
    }

    public FragmentAssemblerOptions setAddress(String address) {
        this.address = address;
        return this;
    }

    public UnprocessedFragmentStrategy getUnprocessedStrategy() {
        return this.unprocessedStrategy;
    }

    public FragmentAssemblerOptions setUnprocessedStrategy(UnprocessedFragmentStrategy unprocessedStrategy) {
        this.unprocessedStrategy = unprocessedStrategy;
        return this;
    }

    public SnippetOptions getSnippetOptions() {
        return this.snippetOptions;
    }

    public FragmentAssemblerOptions setSnippetOptions(SnippetOptions snippetOptions) {
        this.snippetOptions = snippetOptions;
        return this;
    }
}

